package ru.yandex.search.messenger.proxy.suggest.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.messenger.proxy.suggest.SuggestItem;
import ru.yandex.search.messenger.proxy.suggest.rules.providers.SuggestRequestContextProvider;
import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class MergeResultsRule<
        T extends RequestsProvider,
        U,
        R extends SuggestItem>
    implements SearchRule<T, List<R>>
{
    private final ChainedSearchRule<T, U, String, List<R>> next;

    public MergeResultsRule(
        final ChainedSearchRule<T, U, String, List<R>> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super List<R>> callback)
        throws HttpException
    {
        SuggestRequestContextProvider provider = (SuggestRequestContextProvider) input;
        List<String> requests = input.requests();
        MultiFutureCallback<List<R>> multiCallback =
            new MultiFutureCallback<>(new Callback<>(provider.suggestRequestContext().logger(), callback));
        for (String request: requests) {
            next.execute(input, request, multiCallback.newCallback());
        }
        multiCallback.done();
    }

    private static class Callback<R extends SuggestItem>
        extends AbstractFilterFutureCallback<List<List<R>>, List<R>>
    {
        private final Logger logger;
        Callback(
            final Logger logger,
            final FutureCallback<? super List<R>> callback) {
            super(callback);

            this.logger = logger;
        }

        @Override
        public void completed(final List<List<R>> results) {
            List<R> allResults = new ArrayList<>();
            for (List<R> result: results) {
                allResults.addAll(result);
            }
            Collections.sort(allResults);
            logger.info("Merging results sources:" + results.size() + " total " +  allResults.size());
            callback.completed(allResults);
        }

        @Override
        public void failed(final Exception e) {
            logger.log(Level.WARNING, "Merging failed:", e);
            super.failed(e);
        }
    }
}

