package ru.yandex.search.messenger.proxy.suggest.rules;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.search.messenger.proxy.suggest.AcceptAllUsersFilter;
import ru.yandex.search.messenger.proxy.suggest.UsersFilter;
import ru.yandex.search.messenger.proxy.suggest.rules.providers.SuggestRequestContextProvider;
import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class ResolveAllUsersRule<
    T extends RequestProvider & SuggestRequestContextProvider,
    U,
    R>
    implements SearchRule<T, R>
{
    private final ChainedSearchRule<T, U, UsersFilter, R> next;

    public ResolveAllUsersRule(
        final ChainedSearchRule<T, U, UsersFilter, R> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super R> callback)
        throws HttpException
    {
        next.execute(input, AcceptAllUsersFilter.INSTANCE, callback);
    }
}

