package ru.yandex.search.messenger.proxy.suggest.rules;

import java.util.Collections;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.search.messenger.UserClearedChats;
import ru.yandex.search.messenger.proxy.suggest.AcceptAllChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.BasicChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.ChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.rules.providers.SuggestRequestContextProvider;
import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class ResolveChatRule<
    T extends RequestProvider & SuggestRequestContextProvider,
    U,
    R>
    implements SearchRule<T, R>
{
    private static final String CHAT_ID_FILTER = "chat-id-filter";

    private final ChainedSearchRule<T, U, ChatsFilter, R> next;

    public ResolveChatRule(final ChainedSearchRule<T, U, ChatsFilter, R> next) {
        this.next = next;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super R> callback)
        throws HttpException
    {
        ChatsFilter filter;
        ProxySession session = input.suggestRequestContext().session();
        final String chatId =
            session.params().getString(CHAT_ID_FILTER, null);
        if (chatId == null) {
            filter = AcceptAllChatsFilter.INSTANCE;
        } else {
            filter = new BasicChatsFilter(Collections.singletonMap(chatId, UserClearedChats.DEFAULT_VALUE));
        }
        next.execute(input, filter, callback);
    }
}
