package ru.yandex.search.messenger.proxy.suggest.rules;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import ru.yandex.function.IteratorSupplierAdapter;
import ru.yandex.search.messenger.proxy.Synonyms;

public class SynonymsFieldsTermsSupplierFactory
    implements Function<String, SynonymsFieldsTermsSupplier>
{
    private final List<String> fields;
    private final float initialBoost;
    private final Synonyms synonyms;

    public SynonymsFieldsTermsSupplierFactory(
        final float initialBoost,
        final Synonyms synonyms,
        final String... fields)
    {
        this(initialBoost, synonyms, Arrays.asList(fields));
    }

    public SynonymsFieldsTermsSupplierFactory(
        final float initialBoost,
        final Synonyms synonyms,
        final List<String> fields)
    {
        this.initialBoost = initialBoost;
        this.synonyms = synonyms;
        this.fields = fields;
    }

    @Override
    public SynonymsFieldsTermsSupplier apply(final String token) {
        return new SynonymsFieldsTermsSupplier(
            new IteratorSupplierAdapter<>(fields.iterator()),
            token,
            initialBoost,
            synonyms);
    }
}

