package ru.yandex.search.messenger.proxy.suggest.rules.chats;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.search.messenger.proxy.suggest.BasicSuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.SuggestItem;
import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.SuggestType;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.search.rules.RequestInfo;

public class ChatsSuggestRequestContext
    extends BasicSuggestRequestContext
{
    private final List<RequestInfo> requests;
    private final List<SearchRequestText> parsedRequests;
    private final List<String> requestsTexts;
    private final FutureCallback<? super List<SuggestItem>> callback;
    private final User user;
    private final Set<String> getFields;
    private final String queryFilter;
    private final List<String> dps;
    private final List<String> postfilters;
    private final long failoverDelay;
    private final boolean localityShuffle;
    private final String requestUserId;
    private final boolean channelsSearch;
    private final SuggestType suggestType;

    // CSOFF: ParameterNumber
    public ChatsSuggestRequestContext(
        final SuggestRequestContext suggestRequestContext,
        final List<RequestInfo> requests,
        final long failoverDelay,
        final boolean localityShuffle,
        final FutureCallback<? super List<SuggestItem>> callback,
        final SuggestType suggestType)
        throws BadRequestException
    {
        super(suggestRequestContext, null);
        this.requests = requests;
        this.callback = callback;
        this.suggestType = suggestType;
        this.channelsSearch = suggestType == SuggestType.CHANNELS;
        if (requests.size() == 0) {
            throw new BadRequestException("Request list is empty");
        }
        parsedRequests = new ArrayList<>(requests.size());
        requestsTexts = new ArrayList<>(requests.size());
        for (RequestInfo request: requests) {
            parsedRequests.add(
                SearchRequestText.parseSuggest(
                    request.request(),
                    false));
            requestsTexts.add(request.request());
        }
        if (v2Org() != null && v2Org() != 0) {
            user = new User(
                suggestRequestContext.proxy().config().v2ChatsService(),
                new LongPrefix(v2Org()));
        } else {
            user = new User(
                suggestRequestContext.proxy().config().chatsService(),
                new LongPrefix(0));
        }

        getFields =
            session().params().get(
                "chat_get",
                new LinkedHashSet<>(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new,
                    ','));
        if (channelsSearch) {
            queryFilter = session().params().getString("channel_filter", null);
            dps = session().params().getAll("channel_dp");
            postfilters = session().params().getAll("channel_postfilter");
        } else {
            queryFilter = session().params().getString("chat_filter", null);
            dps = session().params().getAll("chat_dp");
            postfilters = session().params().getAll("chat_postfilter");
        }
        this.failoverDelay = session().params().getLongDuration(
            "user_failover_delay",
            failoverDelay);
        this.localityShuffle = session().params().getBoolean(
            "user_locality_shuffle",
            localityShuffle);
        this.requestUserId = session().params().getString(
            "request-user-id",
            null);
    }
    // CSON: ParameterNumber

    @Override
    public User user() {
        return user;
    }

    public List<RequestInfo> requests() {
        return requests;
    }

    public List<SearchRequestText> parsedRequests() {
        return parsedRequests;
    }

    public List<String> requestsTexts() {
        return requestsTexts;
    }

    public FutureCallback<? super List<SuggestItem>> callback() {
        return callback;
    }

    public Set<String> getFields() {
        return getFields;
    }

    public String queryFilter() {
        return queryFilter;
    }

    public List<String> dps() {
        return dps;
    }

    public List<String> postfilters() {
        return postfilters;
    }

    public long failoverDelay() {
        return failoverDelay;
    }

    public boolean localityShuffle() {
        return localityShuffle;
    }

    public String requestUserId() {
        return requestUserId;
    }

    public boolean channelsSearch() {
        return channelsSearch;
    }

    public SuggestType suggestType() {
        return suggestType;
    }
}
