package ru.yandex.search.messenger.proxy.suggest.rules.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.search.messenger.proxy.suggest.AcceptAllChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.BasicSuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.ChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.SuggestItem;
import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.StringPrefix;
import ru.yandex.search.request.util.SearchRequestText;

public class MessagesSuggestRequestContext
    extends BasicSuggestRequestContext {
    private final SearchRequestText request;
    //        private final String type;
    private final FutureCallback<? super List<SuggestItem>> callback;
    private final ChatsFilter chatsFilter;
    private final Set<String> getFields;
    private final String queryFilter;
    private final List<String> dps;
    private final List<String> postfilters;
    private final long failoverDelay;
    private final boolean localityShuffle;
    private final List<ShardContext> subContexts;
    private final boolean globalSearch;
    private final String service;
    private final ChatMediaFilter mediaTypeFilter;
    private final boolean base64Out;
    private final boolean jsonOut;

    // CSOFF: ParameterNumber
    public MessagesSuggestRequestContext(
        final SuggestRequestContext suggestRequestContext,
        final String requestString,
        final SearchRequestText request,
        final ChatsFilter chatsFilter,
        final long failoverDelay,
        final boolean localityShuffle,
        final INum[] globalShards,
        final FutureCallback<? super List<SuggestItem>> callback)
        throws BadRequestException {
        super(suggestRequestContext, requestString);
        this.request = request;
        this.callback = callback;
        this.chatsFilter = chatsFilter;
        service = suggestRequestContext.proxy().config().messagesService();
        base64Out = session().params().getBoolean(
            "message_base64_data",
            true);
        jsonOut = session().params().getBoolean(
            "message_json_data",
            true);
        getFields =
            session().params().get(
                "message_get",
                new LinkedHashSet<>(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new,
                    ','));
        queryFilter = session().params().getString("message_filter", null);
        mediaTypeFilter = session().params().getEnum(ChatMediaFilter.class, "media_type_filter", null);
        dps = session().params().getAll("message_dp");
        postfilters = session().params().getAll("message_postfilter");
//        if (mediaTypeFilter != null && mediaTypeFilter == ChatMediaFilter.LINK) {
//            postfilters = new ArrayList<>(postfilters);
//            postfilters.add("");
//        } else {
//            this.dps = dps
//        }
        this.failoverDelay = session().params().getLongDuration(
            "message_failover_delay",
            failoverDelay);
        this.localityShuffle = session().params().getBoolean(
            "message_locality_shuffle",
            localityShuffle);

        this.globalSearch =
            chatsFilter == AcceptAllChatsFilter.INSTANCE;

        if (globalSearch) {
            subContexts = new ArrayList<>(globalShards.length);
            for (INum iNum : globalShards) {
                session().logger().info("SubContext: global, user: "
                                            + iNum.user() + ", shard: " + iNum.shard());
                subContexts.add(
                    new ShardContext(
                        iNum.user(),
                        iNum.shard(),
                        Collections.emptyMap(),
                        this));
            }
        } else {
            Map<SearchMapShard, Map<String, Long>> shardMap = new HashMap<>();
            Map<SearchMapShard, User> userMap = new HashMap<>();
            for (Map.Entry<String, Long> chatEntry : this.chatsFilter.chats().entrySet()) {
                Prefix prefix = new StringPrefix(chatEntry.getKey());
                User user = new User(
                    suggestRequestContext.proxy().config()
                        .messagesService(),
                    prefix);
                SearchMapShard shard =
                    suggestRequestContext.proxy().searchMap().apply(user);
                Map<String, Long> chats = shardMap.get(shard);
                if (chats == null) {
                    chats = new LinkedHashMap<>(2);
                    shardMap.put(shard, chats);
                    userMap.put(shard, user);
                }
                chats.put(chatEntry.getKey(), chatEntry.getValue());
            }
            subContexts = new ArrayList<>(shardMap.size());
            for (Map.Entry<SearchMapShard, Map<String, Long>> entry
                : shardMap.entrySet()) {
                User user = userMap.get(entry.getKey());
                session().logger().info("SubContext: prefixed, user: "
                                            + user + ", shard:  " + entry.getKey());
                subContexts.add(
                    new ShardContext(
                        user,
                        entry.getKey(),
                        entry.getValue(),
                        this));
            }
        }
    }
    // CSON: ParameterNumber

    @Override
    public User user() {
        throw new UnsupportedOperationException();
    }

    public SearchRequestText requestText() {
        return request;
    }

    public FutureCallback<? super List<SuggestItem>> callback() {
        return callback;
    }

    public ChatsFilter chatsFilter() {
        return chatsFilter;
    }

    public Set<String> getFields() {
        return getFields;
    }

    public String queryFilter() {
        return queryFilter;
    }

    public List<String> dps() {
        return dps;
    }

    public List<String> postfilters() {
        return postfilters;
    }

    public long failoverDelay() {
        return failoverDelay;
    }

    public boolean localityShuffle() {
        return localityShuffle;
    }

    public List<ShardContext> subContexts() {
        return subContexts;
    }

    public boolean globalSearch() {
        return globalSearch;
    }

    public String service() {
        return service;
    }

    public boolean base64Out() {
        return base64Out;
    }

    public boolean jsonOut() {
        return jsonOut;
    }

    public ChatMediaFilter mediaTypeFilter() {
        return mediaTypeFilter;
    }

    public enum ChatMediaFilter {
        FILE_MESSAGE,
        LINK;
    }
}

