package ru.yandex.search.messenger.proxy.suggest.rules.messages;

import java.util.Map;
import java.util.logging.Logger;

import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class ShardContext
    implements UniversalSearchProxyRequestContext
{
    private final User user;
    private final SearchMapShard shard;
    private final Map<String, Long> chats;
    private final MessagesSuggestRequestContext context;

    //CSOFF: ParameterNumber
    public ShardContext(
        final User user,
        final SearchMapShard shard,
        final Map<String, Long> chats,
        final MessagesSuggestRequestContext context)
    {
        this.user = user;
        this.shard = shard;
        this.chats = chats;
        this.context = context;
    }
    //CSON: ParameterNumber

    @Override
    public User user() {
        return user;
    }

    @Override
    public AsyncClient client() {
        return context.client();
    }

    @Override
    public long lagTolerance() {
        return context.lagTolerance();
    }

    @Override
    public Logger logger() {
        return context.logger();
    }

    @Override
    public Long minPos() {
        return context.minPos();
    }

    public SearchMapShard shard() {
        return shard;
    }

    public Map<String, Long> chats() {
        return chats;
    }
}
