package ru.yandex.search.messenger.proxy.suggest.rules.providers;

import ru.yandex.search.messenger.proxy.suggest.ChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.UsersFilter;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class SuggestRequestContextRequestAllFilterProvider
    implements
        RequestProvider,
        SuggestRequestContextProvider,
        SuggestUsersFilterProvider,
        SuggestChatsFilterProvider
{
    private final SuggestRequestContext suggestRequestContext;
    private final String request;
    private final UsersFilter usersFilter;
    private final ChatsFilter chatsFilter;

    public SuggestRequestContextRequestAllFilterProvider(
        final SuggestRequestContext suggestRequestContext,
        final String request,
        final UsersFilter usersFilter,
        final ChatsFilter chatsFilter)
    {
        this.suggestRequestContext = suggestRequestContext;
        this.request = request;
        this.usersFilter = usersFilter;
        this.chatsFilter = chatsFilter;
    }

    @Override
    public SuggestRequestContext suggestRequestContext() {
        return suggestRequestContext;
    }

    @Override
    public String request() {
        return request;
    }

    @Override
    public UsersFilter usersFilter() {
        return usersFilter;
    }

    @Override
    public ChatsFilter chatsFilter() {
        return chatsFilter;
    }
}

