package ru.yandex.search.messenger.proxy.suggest.rules.providers;

import ru.yandex.search.messenger.proxy.suggest.ChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class SuggestRequestContextRequestChatsFilterProvider
    implements
        RequestProvider,
        SuggestRequestContextProvider,
        SuggestChatsFilterProvider
{
    private final SuggestRequestContext suggestRequestContext;
    private final String request;
    private final ChatsFilter filter;

    public SuggestRequestContextRequestChatsFilterProvider(
        final SuggestRequestContext suggestRequestContext,
        final String request,
        final ChatsFilter filter)
    {
        this.suggestRequestContext = suggestRequestContext;
        this.request = request;
        this.filter = filter;
    }

    @Override
    public SuggestRequestContext suggestRequestContext() {
        return suggestRequestContext;
    }

    @Override
    public String request() {
        return request;
    }

    @Override
    public ChatsFilter chatsFilter() {
        return filter;
    }
}

