package ru.yandex.search.messenger.proxy.suggest.rules.providers;

import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.UsersFilter;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class SuggestRequestContextRequestUsersFilterProvider
    implements
        RequestProvider,
        SuggestRequestContextProvider,
        SuggestUsersFilterProvider
{
    private final SuggestRequestContext suggestRequestContext;
    private final String request;
    private final UsersFilter filter;

    public SuggestRequestContextRequestUsersFilterProvider(
        final SuggestRequestContext suggestRequestContext,
        final String request,
        final UsersFilter filter)
    {
        this.suggestRequestContext = suggestRequestContext;
        this.request = request;
        this.filter = filter;
    }

    @Override
    public SuggestRequestContext suggestRequestContext() {
        return suggestRequestContext;
    }

    @Override
    public String request() {
        return request;
    }

    @Override
    public UsersFilter usersFilter() {
        return filter;
    }
}

