package ru.yandex.search.messenger.proxy.suggest.rules.providers;

import java.util.List;

import ru.yandex.search.messenger.proxy.suggest.ChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class SuggestRequestContextRequestsChatsFilterProvider
    implements
        RequestsProvider,
        SuggestRequestContextProvider,
        SuggestChatsFilterProvider
{
    private final SuggestRequestContext suggestRequestContext;
    private final List<String> requests;
    private final ChatsFilter filter;

    public SuggestRequestContextRequestsChatsFilterProvider(
        final SuggestRequestContext suggestRequestContext,
        final ChatsFilter filter,
        final List<String> requests)
    {
        this.suggestRequestContext = suggestRequestContext;
        this.filter = filter;
        this.requests = requests;
    }

    @Override
    public SuggestRequestContext suggestRequestContext() {
        return suggestRequestContext;
    }

    @Override
    public List<String> requests() {
        return requests;
    }

    @Override
    public ChatsFilter chatsFilter() {
        return filter;
    }
}

