package ru.yandex.search.messenger.proxy.suggest.rules.providers;

import java.util.List;

import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.UsersFilter;
import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class SuggestRequestContextRequestsUsersFilterProvider
    implements
        RequestsProvider,
        SuggestRequestContextProvider,
        SuggestUsersFilterProvider
{
    private final SuggestRequestContext suggestRequestContext;
    private final List<String> requests;
    private final UsersFilter filter;

    public SuggestRequestContextRequestsUsersFilterProvider(
        final SuggestRequestContext suggestRequestContext,
        final UsersFilter filter,
        final List<String> requests)
    {
        this.suggestRequestContext = suggestRequestContext;
        this.filter = filter;
        this.requests = requests;
    }

    @Override
    public SuggestRequestContext suggestRequestContext() {
        return suggestRequestContext;
    }

    @Override
    public List<String> requests() {
        return requests;
    }

    @Override
    public UsersFilter usersFilter() {
        return filter;
    }
}

