package ru.yandex.search.messenger.proxy.suggest.rules.users;

import java.util.Arrays;
import java.util.List;

import ru.yandex.ps.search.messenger.UserFields;
import ru.yandex.search.messenger.proxy.Moxy;
import ru.yandex.search.messenger.proxy.suggest.rules.SynonymsFieldsTermsSupplierFactory;

public abstract class AbstractUserSuggestRule {
    protected static final String SCORE = "#score";
    protected static final String B_AND_B = ") AND (";
    protected static final String AND = " AND ";
    protected static final String OR_B = " OR (";
    protected static final String OR = " OR ";

    protected static final long MICROS_PER_SEC = 1000000;
    protected static final String DISPLAY_NAME = "display_name";
    protected static final String PASSPORT_DISPLAY_NAME = "passport_display_name";

    protected static final String RESOURCE_ID = "user_id";
    protected static final String NAME_TOKENIZED_P =
        UserFields.DISPLAY_NAME_TOKENIZED_P.prefixed();
    protected static final String NICKNAME_TOKENIZED_P =
        UserFields.NICKNAME_TOKENIZED_P.prefixed();
    protected static final String POSITION_TOKENIZED_P =
        UserFields.POSITION_TOKENIZED_P.prefixed();
    protected static final String WEBSITE_TOKENIZED_P =
        UserFields.WEBSITE_TOKENIZED_P.prefixed();

    protected static final String[] SEARCH_FIELDS_TOKENIZED1 = {
        NAME_TOKENIZED_P
    };
    protected static final String[] SEARCH_FIELDS_TOKENIZED2 = {
        NICKNAME_TOKENIZED_P,
        NAME_TOKENIZED_P
    };
    protected static final String[] SEARCH_FIELDS_TOKENIZED3 = {
        WEBSITE_TOKENIZED_P,
        POSITION_TOKENIZED_P,
        NICKNAME_TOKENIZED_P,
        NAME_TOKENIZED_P
    };

    protected static final String[] SEARCH_FIELDS_KEYWORD1 = {
        UserFields.DISPLAY_NAME_P.prefixed()
    };
    protected static final String[] SEARCH_FIELDS_KEYWORD2 = {
        UserFields.NICKNAME_P.prefixed(),
        UserFields.DISPLAY_NAME_P.prefixed()
    };
    protected static final String[] SEARCH_FIELDS_KEYWORD3 = {
        UserFields.WEBSITE_P.prefixed(),
        UserFields.POSITION_P.prefixed(),
        UserFields.NICKNAME_P.prefixed(),
        UserFields.DISPLAY_NAME_P.prefixed()
    };

    protected static final String CONTACT_NAME = "contact_name";

    protected static final String[] MATCH_FIELDS = {
        UserFields.WEBSITE.global(),
        UserFields.POSITION.global(),
        CONTACT_NAME,
        UserFields.NICKNAME.global(),
        UserFields.DISPLAY_NAME.global()
    };
    protected static final String[] LOGIN_FIELDS = {
        NAME_TOKENIZED_P,
        NICKNAME_TOKENIZED_P
    };
    protected static final String[] LOGIN_FIELDS_KEYWORD = {
        UserFields.DISPLAY_NAME_P.prefixed(),
        UserFields.NICKNAME_P.prefixed()
    };

    protected static final List<String> SEARCH_FIELDS_KEYWORD_LIST1 =
        Arrays.asList(SEARCH_FIELDS_KEYWORD1);
    protected static final List<String> SEARCH_FIELDS_KEYWORD_LIST2 =
        Arrays.asList(SEARCH_FIELDS_KEYWORD2);
    protected static final List<String> SEARCH_FIELDS_KEYWORD_LIST3 =
        Arrays.asList(SEARCH_FIELDS_KEYWORD3);

    protected final SynonymsFieldsTermsSupplierFactory nameField1;
    protected final SynonymsFieldsTermsSupplierFactory nameField2;
    protected final SynonymsFieldsTermsSupplierFactory nameField3;

    protected final Moxy moxy;

    public AbstractUserSuggestRule(final Moxy moxy) {
        this.moxy = moxy;

        nameField1 =
            new SynonymsFieldsTermsSupplierFactory(
                1f,
                moxy.synonyms(),
                Arrays.asList(SEARCH_FIELDS_TOKENIZED1));
        nameField2 =
            new SynonymsFieldsTermsSupplierFactory(
                1f,
                moxy.synonyms(),
                Arrays.asList(SEARCH_FIELDS_TOKENIZED2));
        nameField3 =
            new SynonymsFieldsTermsSupplierFactory(
                1f,
                moxy.synonyms(),
                Arrays.asList(SEARCH_FIELDS_TOKENIZED3));
    }

    protected static List<String> keywordFields(final int requestSize) {
        switch (requestSize) {
            case 1:
                return SEARCH_FIELDS_KEYWORD_LIST1;
            case 2:
                return SEARCH_FIELDS_KEYWORD_LIST2;
            default:
                return SEARCH_FIELDS_KEYWORD_LIST3;
        }
    }

    protected SynonymsFieldsTermsSupplierFactory searchFields(
        final int requestSize)
    {
        switch (requestSize) {
            case 1:
                return nameField1;
            case 2:
                return nameField2;
            default:
                return nameField3;
        }
    }


}
