package ru.yandex.search.messenger.proxy.suggest.rules.users;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.messenger.proxy.suggest.BasicSuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.prefix.StringPrefix;

public class ContactsSuggestRequestContext
    extends BasicSuggestRequestContext
{
    private final User user;
    private final long failoverDelay;
    private final boolean localityShuffle;

    // CSOFF: ParameterNumber
    public ContactsSuggestRequestContext(
        final String userId,
        final SuggestRequestContext suggestRequestContext,
        final long failoverDelay,
        final boolean localityShuffle)
        throws BadRequestException
    {
        super(suggestRequestContext, "");
        user = new User(
            suggestRequestContext.proxy().config().messagesService(),
            new StringPrefix(userId));
        this.failoverDelay = session().params().getLongDuration(
            "contact_failover_delay",
            failoverDelay);
        this.localityShuffle = session().params().getBoolean(
            "contact_locality_shuffle",
            localityShuffle);
    }
    // CSON: ParameterNumber

    @Override
    public User user() {
        return user;
    }

    public long failoverDelay() {
        return failoverDelay;
    }

    public boolean localityShuffle() {
        return localityShuffle;
    }
}
