package ru.yandex.search.messenger.proxy.suggest.rules.users;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.search.messenger.proxy.suggest.BasicSuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.ChatsFilter;
import ru.yandex.search.messenger.proxy.suggest.SuggestItem;
import ru.yandex.search.messenger.proxy.suggest.SuggestRequestContext;
import ru.yandex.search.messenger.proxy.suggest.SuggestType;
import ru.yandex.search.messenger.proxy.suggest.UsersFilter;
import ru.yandex.search.messenger.proxy.suggest.rules.ResolveContactsUsersRule;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.request.util.SearchRequestText;

public class UsersSuggestRequestContext
    extends BasicSuggestRequestContext
{
    private static final int TEAM_ORG_ID = 34;
    private static final Pattern EMAIL =
        Pattern.compile("([A-Za-z0-9._%+-]+)@([A-Za-z0-9.-]+\\.[A-Za-z]{2,4})");

    private final SearchRequestText request;
    //        private final String type;
    private final FutureCallback<? super List<SuggestItem>> callback;
    private final User user;
    private final UsersFilter usersFilter;
    private final ChatsFilter chatsFilter;
    private final Set<String> getFields;
    private final Set<String> contactGetFields;
    private final String queryFilter;
    private final List<String> dps;
    private final List<String> postfilters;
    private final long failoverDelay;
    private final boolean localityShuffle;
    private final SuggestType resultsSuggestType;
    private final boolean contactsSearch;
    private final boolean pvp;
    private final ContactsSuggestRequestContext contactsContext;
    private final String mboxSearch;
    private final String userGuid;
    private final String database;

    // CSOFF: ParameterNumber
    public UsersSuggestRequestContext(
        final SuggestRequestContext suggestRequestContext,
        final String requestString,
        final SearchRequestText request,
        final UsersFilter usersFilter,
        final ChatsFilter chatsFilter,
        final boolean pvp,
        final long failoverDelay,
        final boolean localityShuffle,
        final SuggestType resultsSuggestType,
        final FutureCallback<? super List<SuggestItem>> callback,
        final boolean contactsSearch)
        throws BadRequestException
    {
        super(suggestRequestContext, requestString);
        this.request = request;
        this.callback = callback;
        this.usersFilter = usersFilter;
        this.chatsFilter = chatsFilter;
        this.resultsSuggestType = resultsSuggestType;
        this.contactsSearch = contactsSearch;
        this.pvp = pvp;
        long userId = 0;
        if (suggestRequestContext.v2Org() != null) {
            userId = suggestRequestContext.v2Org();
            database = "v2org";
        } else {
            if (!contactsSearch && !pvp) {
                String organizations =
                    session().params().getString("organizations", null);
                if (organizations != null) {
                    String[] orgs = organizations.split(",");
                    String orgId = orgs[0].trim();
                    try {
                        userId = Long.parseLong(orgId);
                    } catch (NumberFormatException e) {
                        //ignore
                        userId = 0;
                    }
                }
            }

            database = null;
        }

        String mboxSearch = null;
        if (userId == TEAM_ORG_ID) {
            Matcher m = EMAIL.matcher(requestString);
            if (m.matches()) {
                String mbox = m.group(1);
                String host = m.group(2);
                session().logger().info(
                    "Dropping email's domain part from: "
                        + requestString
                        + ", mbox: " + mbox
                        + ", host: " + host);
                if (host.equalsIgnoreCase("yandex-team.ru")
                    || host.equalsIgnoreCase("yandex-team.com")
                    || host.equalsIgnoreCase("auto.ru")
                    || host.equalsIgnoreCase("yamoney.ru"))
                {
                    mboxSearch = mbox;
                }
            }
        }
        this.mboxSearch = mboxSearch;

        session().logger().info("v2usersService " + suggestRequestContext.proxy().config().v2UsersService());
        if (suggestRequestContext.v2Org() != null && suggestRequestContext.v2Org() != 0) {
            user = new User(
                suggestRequestContext.proxy().config().v2UsersService(),
                new LongPrefix(suggestRequestContext.v2Org()));
            session().logger().info("v2user " + user);
        } else {
            user = new User(
                suggestRequestContext.proxy().config().usersService(),
                new LongPrefix(userId));
        }
        getFields =
            session().params().get(
                "user_get",
                new LinkedHashSet<>(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new,
                    ','));
        if (contactsSearch) {
            contactGetFields =
                session().params().get(
                    "contact_get",
                    new LinkedHashSet<>(),
                    new CollectionParser<>(
                        String::trim,
                        LinkedHashSet::new,
                        ','));
            contactGetFields.add(AbstractUserSuggestRule.CONTACT_NAME);
        } else {
            contactGetFields = Collections.emptySet();
        }
        if (pvp) {
            String userFilter = session().params().getString("pvp_user_filter", null);
            if (v2Org() != null && v2Org() != 0 && userFilter != null) {
                userFilter = userFilter.replaceFirst("user_org_id:0", "user_org_id:" + v2Org());
            }

            queryFilter = userFilter;
            dps = session().params().getAll("pvp_user_dp");
            postfilters = session().params().getAll("pvp_user_postfilter");
        } else if (contactsSearch) {
            queryFilter =
                session().params().getString(
                    "contacts_user_filter",
                    "user_org_id:0 AND user_is_dismissed:false"
                        + " AND user_is_robot:false");
            dps = session().params().getAll("contacts_user_dp");
            postfilters =
                session().params().getAll("contacts_user_postfilter");
        } else {
            String userFilter = session().params().getString("user_filter", null);
            if (v2Org() != null && v2Org() != 0 && userFilter != null) {
                userFilter = userFilter.replaceFirst("user_org_id:0", "user_org_id:" + v2Org());
            }
            queryFilter = userFilter;
            //queryFilter = session().params().getString("user_filter", null);
            dps = session().params().getAll("user_dp");
            postfilters = session().params().getAll("user_postfilter");
        }
        this.failoverDelay = session().params().getLongDuration(
            "user_failover_delay",
            failoverDelay);
        this.localityShuffle = session().params().getBoolean(
            "user_locality_shuffle",
            localityShuffle);
        userGuid = session().params().getString(
            ResolveContactsUsersRule.REQUEST_USER_ID,
            null);
        if (userGuid == null) {
            contactsContext = null;
        } else {
            contactsContext =
                new ContactsSuggestRequestContext(
                    userGuid,
                    suggestRequestContext,
                    failoverDelay,
                    localityShuffle);
        }
    }
    // CSON: ParameterNumber

    @Override
    public User user() {
        return user;
    }

    public String database() {
        return database;
    }

    public FutureCallback<? super List<SuggestItem>> callback() {
        return callback;
    }

    public UsersFilter usersFilter() {
        return usersFilter;
    }

    public String userGuid() {
        return userGuid;
    }

    public ContactsSuggestRequestContext contactsContext() {
        return contactsContext;
    }

    public Set<String> getFields() {
        return getFields;
    }

    public Set<String> contactGetFields() {
        return contactGetFields;
    }

    public SuggestType resultsSuggestType() {
        return resultsSuggestType;
    }

    public boolean pvp() {
        return pvp;
    }

    public boolean contactsSearch() {
        return contactsSearch;
    }

    public long failoverDelay() {
        return failoverDelay;
    }

    public boolean localityShuffle() {
        return localityShuffle;
    }

    public SearchRequestText requestText() {
        return request;
    }
}
