package ru.yandex.search.messenger.proxy.topposts;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import NMessengerProtocol.Client;
import NMessengerProtocol.Search;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.ps.search.messenger.ChatFields;
import ru.yandex.ps.search.messenger.UserFields;
import ru.yandex.search.messenger.UserChats;

public class Chat implements JsonValue {
    private final String chatId;
    private final String name;
    private final String description;
    private final String inviteHash;
    private final String avatarId;
    private final int memberCount;
    private final boolean isMember;
    private final List<Message> messages;

    public Chat(final JsonMap json, final List<Message> messages) {
        this.messages = messages;

        chatId = json.getOrNull(ChatFields.ID.stored());
        name = json.getOrNull(ChatFields.NAME.stored());
        description = json.getOrNull(ChatFields.DESCRIPTION.stored());
        inviteHash = json.getOrNull(ChatFields.INVITE_HASH.stored());
        avatarId = json.getOrNull(ChatFields.AVATAR_ID.stored());
        String members = json.getOrNull(ChatFields.MEMBERS.stored());
        String userChats = json.getOrNull(UserChats.CHATS.stored());
        String guid = json.getOrNull(UserFields.ID.stored());
        if (members == null) {
            memberCount = 0;
            isMember = false;
        } else {
            String[] membersArray = members.split("\n");
            memberCount = membersArray.length;
            if (guid != null
                && Arrays.stream(membersArray).anyMatch(guid::equals))
            {
                isMember = true;
            } else if (userChats != null && !userChats.isEmpty() && chatId != null){
                String[] userChatsArray = userChats.split("\n");
                boolean isMemberByUserChats = false;
                for (String chat: userChatsArray) {
                    if (chatId.equalsIgnoreCase(chat)) {
                        isMemberByUserChats = true;
                        break;
                    }
                }

                isMember = isMemberByUserChats;
            } else {
                isMember = false;
            }
        }
    }

    public Chat(final Chat chat, final boolean isMember) {
        this.messages = chat.messages;

        chatId = chat.chatId;
        name = chat.name;
        description = chat.description;
        inviteHash = chat.inviteHash;
        avatarId = chat.avatarId;
        memberCount = chat.memberCount;
        this.isMember = isMember;
    }

    public String name() {
        return name;
    }

    public String description() {
        return description;
    }

    public String inviteHash() {
        return inviteHash;
    }

    public String avatarId() {
        return avatarId;
    }

    public int memberCount() {
        return memberCount;
    }

    public boolean member() {
        return isMember;
    }

    public String chatId() {
        return chatId;
    }

    public List<Message> messages() {
        return messages;
    }

    public Search.TTopPosts toProto(final int length, final int[] postCount) {
        Search.TTopPosts.Builder builder = Search.TTopPosts.newBuilder();
        builder.setChatId(chatId);
        if (name != null) {
            builder.setName(name);
        }
        if (description != null) {
            builder.setDescription(description);
        }
        if (inviteHash != null) {
            builder.setInviteHash(inviteHash);
        }
        if (avatarId != null) {
            builder.setAvatarId(avatarId);
        }
        builder.setMemberCount(memberCount);
        builder.setIsMember(isMember);

        int i = 0;
        for (Message message: messages) {
            Client.TServerMessage messageProto = message.serverMessageProto();
            if (messageProto != null) {
                if (i++ >= length) {
                    break;
                }
                builder.addMessages(messageProto);
                postCount[0]++;
                if (message.hasImage()) {
                    builder.addPreviews(
                        Search.TPostPreviewInfo.newBuilder()
                            .setUrl(message.imageUrl())
                            .setWidth(message.imageWidth())
                            .setHeight(message.imageHeight())
                            .setMessageTimestamp(message.timestamp())
                            .build());
                }
            }
        }
        return builder.build();
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writeJson(writer, messages.size());
    }

    public int writeJson(final JsonWriterBase writer, final int length)
        throws IOException
    {
        writer.startObject();

        writer.key("chat_id");
        writer.value(chatId);

        writer.key("chat_name");
        writer.value(name);

        writer.key("chat_description");
        writer.value(description);

        writer.key("chat_invite_hash");
        writer.value(inviteHash);

        writer.key("chat_avatar_id");
        writer.value(avatarId);

        writer.key("chat_member_count");
        writer.value(memberCount);

        writer.key("user_is_member");
        writer.value(isMember);

        writer.key("chat_top_messages");
        writer.startArray();
        int i = 0;
        for (Message message: messages) {
            if (i++ >= length) {
                break;
            }
            message.writeJson(writer);
        }
        writer.endArray();
        writer.endObject();
        return i;
    }
}
