package ru.yandex.search.messenger.proxy.topposts;

import org.apache.http.HttpException;

import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.ps.search.messenger.UserFields;
import ru.yandex.search.messenger.UserChats;
import ru.yandex.search.prefix.LongPrefix;

public class ChatsListByUidContext extends RequestContext {
    private static final String GET_FIELDS = UserFields.ID.stored() + ',' + UserChats.CHATS.stored();
    private final User user;

    public ChatsListByUidContext(
        final TopPostsRequestContext context)
        throws HttpException
    {
        super(context);

        user = new User(context.config().usersService(), new LongPrefix(0L));
    }

    @Override
    protected String service() {
        return user.service();
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    protected QueryConstructor createQuery(
        final TopPostsRequestContext context)
        throws HttpException
    {
        StringBuilder textSb = new StringBuilder();
        textSb.append(UserFields.UID.global());
        textSb.append(':');
        textSb.append(context.uid());
        QueryConstructor query =
            new QueryConstructor(
                "/search?IO_PRIO=0&json-type=dollar&sync-searcher=false");
        query.append("get", GET_FIELDS);
        query.append("prefix", user.prefix().toStringFast());
        query.append("service", user.service());
        query.append("text", textSb.toString());
        query.append("length", "1");
        query.append("dp", "const(user_chats_ id_prefix)");
        query.append("dp", "concat(id_prefix,user_id user_chats_id)");
        query.append("dp", "left_join(user_chats_id,id,,user_chats user_chats)");

        return query;
    }
}
