package ru.yandex.search.messenger.proxy.topposts;

import org.apache.http.HttpException;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.messenger.ChatFields;
import ru.yandex.search.prefix.LongPrefix;

public class ChatsRequestContext extends RequestContext {
    public ChatsRequestContext(
        final TopPostsRequestContext context)
        throws HttpException
    {
        super(context);
    }

    @Override
    protected String service() {
        return topContext().config().chatsService();
    }

    @Override
    protected QueryConstructor createQuery(
        final TopPostsRequestContext context)
        throws HttpException
    {
        QueryConstructor query = new QueryConstructor(
            "/search?json-type=dollar&IO_PRIO=0"
                + "&get=chat_id,chat_name,chat_description,chat_invite_hash"
                + ",chat_avatar_id,chat_members");
        query.append(
            "text",
            searchText(context));
        query.append("prefix", "0");
        if (context.uid() != null) {
            query.append("dp", "const(" + context.uid() + " user_uid)");
            query.append(
                "dp",
                "left_join(user_uid,user_uid,,user_id user_id)");
            query.append("dp", "const(user_chats_ id_prefix)");
            query.append("dp", "concat(id_prefix,user_id user_chats_id)");
            query.append("dp", "left_join(user_chats_id,id,,user_chats user_chats)");
            query.append("get", "user_id,user_chats");
        }
        TopPostsHandler.applyTimestampPostFilter(
            query,
            ChatFields.LAST_MESSAGE_TIMESTAMP.global(),
            context.daysDepth());

        return query;
    }

    protected String searchText(
        final TopPostsRequestContext context)
    {
        final StringBuilder sb = new StringBuilder();
        sb.append("chat_show_on_morda:true");
        sb.append(" AND ");
        TopPostsHandler.applyTimestampFilter(
            ChatFields.LAST_MESSAGE_DAY.global(),
            sb,
            context.daysDepth());

        return new String(sb);
    }

    @Override
    protected User user() {
        return new User(service(), new LongPrefix(0));
    }

    public PrefixedLogger logger() {
        return topContext().logger();
    }
}
