package ru.yandex.search.messenger.proxy.topposts;

import org.apache.http.HttpException;

import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;

public abstract class RequestContext {
    private TopPostsRequestContext context;

    public RequestContext(
        final TopPostsRequestContext context)
        throws HttpException
    {
        this.context = context;
    }

    protected abstract User user();

    protected abstract String service();

    protected QueryConstructor query() throws HttpException {
        return createQuery(context);
    }

    protected abstract QueryConstructor createQuery(
        final TopPostsRequestContext context)
        throws HttpException;

    public TopPostsRequestContext topContext() {
        return context;
    }
}
