package ru.yandex.search.messenger.proxy.topposts;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;

public class ReusableCodedInputStream {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 1024;

    private CodedInputStream cis;
    private LimitingByteArrayInputStream bis;
    private byte[] array;

    public ReusableCodedInputStream() {
        allocate(DEFAULT_BYTE_ARRAY_LENGTH);
    }

    private void allocate(final int size) {
        array = new byte[size];
        bis = new LimitingByteArrayInputStream(array);
        bis.mark(0);
        cis = CodedInputStream.newInstance(bis);
    }

    public void checkSize(final int size)
        throws InvalidProtocolBufferException
    {
        if (array.length < size) {
            allocate(size << 1);
        }
        bis.limit(size);
        cis.setSizeLimit(size);
        cis.resetSizeCounter();
    }

    public void reset() {
        bis.reset();
        bis.mark(0);
    }

    public byte[] array() {
        return array;
    }

    public CodedInputStream cis() {
        return cis;
    }

    public LimitingByteArrayInputStream bis() {
        return bis;
    }
}
