package ru.yandex.search.messenger.proxy.topposts;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.ps.search.messenger.MessageFields;
import ru.yandex.search.messenger.proxy.config.ImmutableMoxyConfig;

public class TopPostsRequestContext {
    private static final int DEFAULT_LENGTH = 30;
    private static final CollectionParser<
        String,
        Set<String>,
        Exception>
        SET_PARSER = new CollectionParser<>(
        String::trim,
//            NonEmptyValidator.INSTANCE,
        LinkedHashSet::new);
    private static final Set<String> DEFAULT_MESSAGE_TYPES =
        new LinkedHashSet<>(
            Arrays.asList("text_message", "gallery_message"));

    private static final boolean ALLOW_LAGGING_HOSTS = true;

    private final int length;
    private final String get;
    private final String sort;
    private final String asc;
    private final boolean localityShuffle;
    private final boolean allowLaggingHosts;
    private final long failoverDelay;
    private final int daysDepth;
    private final boolean filterEmptyText;
    private final Set<String> chatIds;
    private final Collection<String> types;
    private final Collection<String> moderationActions;
    private final boolean protobufOut;
    private final Long uid;
    private final boolean skipMessagesRequest;
    private int postCount = 0;
    private final PrefixedLogger logger;
    private final ImmutableMoxyConfig config;

    public TopPostsRequestContext(
        final CgiParams params,
        final PrefixedLogger logger,
        final ImmutableMoxyConfig config)
        throws HttpException
    {
        this.logger = logger;
        this.length = params.getInt("length", DEFAULT_LENGTH);
        String get =
            params.getString("get", null);
        this.get = get;
        sort =
            params.getString("sort", MessageFields.SEQ_NO.stored());
        asc = params.getString("asc", "true");
        this.uid = params.getLong("uid", null);
        this.localityShuffle = params.getBoolean(
            "locality-shuffle",
            config.topPostsLocalityShuffle());
        this.failoverDelay = params.getLong(
            "failover-delay",
            config.topPostsFailoverDelay());
        this.allowLaggingHosts = params.getBoolean(
            "allow-lagging-hosts",
            ALLOW_LAGGING_HOSTS);
        this.chatIds = params.getAll(
            "chat-ids",
            new HashSet<>(),
            SET_PARSER);
        this.types = params.getAll(
            "types",
            DEFAULT_MESSAGE_TYPES,
            SET_PARSER);
        this.moderationActions = params.getAll(
            "moderation-actions",
            Collections.singleton("keep"),
            SET_PARSER);
        this.skipMessagesRequest =
            params.getBoolean("skip-messages-request", false);
        this.daysDepth = params.getInt("days-depth", 5);
        this.protobufOut = params.getBoolean("proto", false);
        this.filterEmptyText = params.getBoolean(
            "filter-empty-text",
            true);
        this.config = config;
    }

    public ImmutableMoxyConfig config() {
        return config;
    }

    public int length() {
        return length;
    }

    public String sort() {
        return sort;
    }

    public Long uid() {
        return uid;
    }

    public boolean skipMessagesRequest() {
        return skipMessagesRequest;
    }

    public String get() {
        return get;
    }

    public String asc() {
        return asc;
    }

    public Collection<String> chatIds() {
        return chatIds;
    }

    public Collection<String> types() {
        return types;
    }

    public int daysDepth() {
        return daysDepth;
    }

    public Collection<String> moderationActions() {
        return moderationActions;
    }

    public boolean proto() {
        return protobufOut;
    }

    public boolean filterEmptyText() {
        return filterEmptyText;
    }

    public PrefixedLogger logger() {
        return logger;
    }

    public boolean localityShuffle() {
        return localityShuffle;
    }

    public boolean allowLaggingHosts() {
        return allowLaggingHosts;
    }

    public long failoverDelay() {
        return failoverDelay;
    }

    public boolean protobufOut() {
        return protobufOut;
    }

    public int postCount() {
        return postCount;
    }
}
