#!/bin/bash
set -xo pipefail

source messenger_base_config.sh

export NGINX_PORT=48470
export NGINX_SSL_PORT=48471
export TVM_STRICT=false
export MOXY_TVM_CONF=moxy-notvm.conf
export TVM_API_HOST=https://tvm-api.yandex.net

export PS_ABCSERVICE="pssearch"
export PS_PROJECT="messenger"
export PUSHCLIENT_DEFAULT_TOPIC="/$PS_ABCSERVICE/logs/${PS_PROJECT}-access-log"
export YT_ACCESS_LOG=/logs/moxy-access.yt.log
export PUSHCLIENT_DEFAULT_LOG_NAME=$YT_ACCESS_LOG
export FULL_LOG_LEVEL=all
export REC_CHANNELS_GOOD_VERDICTS="ok,ensured_ok,office_ok,text_yang_channel_politics,text_yang_channel_trash,text_auto_caps"

case "$NANNY_SERVICE_ID" in
    messenger_search_proxy_test)
        export NGINX_SERVER_NAME=messenger-search-proxy-test.pers.yandex.net
        export TVM_MESSENGER_ALLOWED_SRCS="$TVM_CLIENT_ID,2001982,2000481,2018208"
        export MOXY_TVM_CONF=moxy-tvm.conf
        export MOXY_CONF=moxy_messenger.conf
        export REC_CHANNELS_GOOD_VERDICTS="any"
        ;;
    messenger_search_proxy_prod_man|messenger_search_proxy_prod_myt|messenger_search_proxy_prod_sas)
        export NGINX_SERVER_NAME=messenger-search-proxy.pers.yandex.net
        export TVM_MESSENGER_ALLOWED_SRCS="$TVM_CLIENT_ID,2002028,2000482,2018206"
        export ORG_CHATS_SERVICE=messenger_org_chats
        export ORG_USERS_SERVICE=messenger_org_users
        export MOXY_TVM_CONF=moxy-tvm.conf
        export TVM_STRICT=true
        export MOXY_CONF=moxy_messenger.conf
        ;;
    messenger_search_proxy_mass_prod_man|messenger_search_proxy_mass_prod_vla|messenger_search_proxy_mass_prod_sas)
        export NGINX_SERVER_NAME=messenger-search-proxy.pers.yandex.net
        export TVM_MESSENGER_ALLOWED_SRCS="$TVM_CLIENT_ID,2002028,2000482,2018206"
        export ORG_CHATS_SERVICE=messenger_org_chats
        export ORG_USERS_SERVICE=messenger_org_users
        export MOXY_TVM_CONF=moxy-tvm.conf
        export FULL_LOG_LEVEL=severe
        export TVM_STRICT=true
        export GZIP=./fakegzip.sh
        export G1=true
        export MOXY_CONF=moxy_mass.conf
        ;;
    messenger_search_proxy_prod_qa)
        export NGINX_PORT=80
        export NGINX_SSL_PORT=443
        export NGINX_SERVER_NAME=messenger-search-proxy.pers.yandex.net
        export TVM_MESSENGER_ALLOWED_SRCS="$TVM_CLIENT_ID,2002028,2000482,2018206"
        export ORG_CHATS_SERVICE=messenger_org_chats
        export ORG_USERS_SERVICE=messenger_org_users
        export MOXY_TVM_CONF=moxy-tvm.conf
        export MOXY_CONF=moxy_messenger.conf
        ;;
    messenger_search_proxy_alpha_man|messenger_search_proxy_alpha_sas|messenger_search_proxy_alpha_myt)
        export NGINX_SERVER_NAME=messenger-search-proxy-alpha.pers.yandex.net
        export TVM_MESSENGER_ALLOWED_SRCS="$TVM_CLIENT_ID,2001984,2001664"
        export MOXY_TVM_CONF=moxy-tvm.conf
        export MOXY_CONF=moxy_messenger.conf
        export REC_CHANNELS_GOOD_VERDICTS="any"
        export ORG_CHATS_SERVICE=messenger_chats_alpha
        export ORG_USERS_SERVICE=messenger_users_alpha
        ;;
esac
