#!/bin/bash
set -exo pipefail

source moxy_config.sh

source classpath.sh

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

if jdk/bin/java -version 2>&1 | fgrep -q -e OpenJ9 -e Ibm -e IBM; then
    GC_ARGS="-Xgcpolicy:gencon -Xgcthreads$CPU_CORES -verbose:gc -Xverbosegclog:/dev/shm/gclogs/gc#.log,10,10000"
else
    if [ "$G1" == "true" ]; then
        GC_ARGS="
            -XX:ActiveProcessorCount=$CPU_CORES
            -XX:+IgnoreUnrecognizedVMOptions
            -XX:+PrintGC
            -XX:+PrintGCDetails
            -XX:+UnlockExperimentalVMOptions
            -verbose:gc
            -XX:+UseG1GC
            -XX:ConcGCThreads=1
            -XX:ParallelGCThreads=$CPU_CORES
            -XX:+UnlockDiagnosticVMOptions
            -XX:+PrintGCDateStamps
            -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
            -XX:MaxGCPauseMillis=10
            -XX:G1MixedGCCountTarget=32
            -XX:G1HeapWastePercent=20
            -XX:G1AdaptiveIHOPNumInitialSamples=10
            -Xloggc:/dev/shm/gc.log"
    else
        GC_ARGS="
        -XX:+PrintGC
        -XX:+PrintGCDetails
        -XX:+UnlockExperimentalVMOptions
        -verbose:gc
        -XX:+UseShenandoahGC
        -XX:ConcGCThreads=1
        -XX:ShenandoahGCMode=traversal
        -XX:-ShenandoahAlwaysClearSoftRefs
        -XX:ShenandoahAllocationThreshold=10
        -XX:ShenandoahGuaranteedGCInterval=30000
        -XX:ParallelGCThreads=$CPU_CORES
        -XX:+UnlockDiagnosticVMOptions
        -Xloggc:/dev/shm/gc.log
        "
    fi
fi

export PROXY_WORKERS=$((CPU_CORES / 2))
export PROXY_WORKERS=$((CPU_CORES>0 ? CPU_CORES : 1))
#export PROXY_WORKERS=$((PROXY_WORKERS - 1))

MEM_ARGS="-Xmx$MEMORY_LIMIT"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $NET_ARGS $MEM_ARGS \
    -Djava.library.path=. \
    -Djava.library.path=./moxy_service \
    -cp $CLASSPATH ru.yandex.search.messenger.proxy.Moxy \
    $MOXY_CONF
