#!/usr/bin/python
# -*- coding: utf-8 -*-
import SocketServer
import json
import os
import shutil
import datetime
import requests
import sys

import subprocess as sp

from collections import OrderedDict

import signal
from requests.adapters import HTTPAdapter

from SimpleHTTPServer import SimpleHTTPRequestHandler

SANDBOX_IGNORE = ['INSTANCECTL', 'STATBOX_PUSHCLIENT']
REPLACE_PATHS = {'/db/bsconfig/': '/', '/usr/local/www/logs/': '/usr-logs/', '/ssd/': '/ssd/', '/dev/shm/': '/shm/'}

INSTANCECTL_TASK = '105551812'

SANDBOX_CACHE = {}

# limits
XMN = '512m'
XMS = '1G'
XMX = '1G'
# nanny
nanny_session = requests.Session()
nanny_session.mount('nanny.yandex-team.ru', HTTPAdapter(max_retries=5))
NANNY_URL = 'https://nanny.yandex-team.ru/v2/services/{service_id}/active/runtime_attrs/'

# sandbox
SANDBOX_HOST = 'sandbox.yandex-team.ru'
SANDBOX_URL = 'https://proxy.' + SANDBOX_HOST + '/{resource_id}'
SANDBOX_RESOURCE_API = 'https://' + SANDBOX_HOST + '/api/v1.0/resource?task_id={task_id}&limit=100'
sandbox_session = requests.Session()
sandbox_session.mount(SANDBOX_HOST, HTTPAdapter(max_retries=5))

# tvm
ROBOT_KEY = 'MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCbSx0rYkAPcJnG4VSXfoRur_AaCd0pTAIYlt424LbiiAaelMLYgY-B' \
            'fqbkcbV7aaAKYI2Wo-CZb82wQjYWIRXsNYfkbZNVubAwajkKTpnoB29ooooaLHtP_tYl7d9gCmrfEGxTdzlwVRmlzyVxgFnnKlKclOf4' \
            'tZS8cE8FCvl0rtjgPlcrHQmMj_c56exomFbDw6aB1tmFgA7jGFOHm607ScVHkt_H5OTCK2bJUUD6aS_fLKVJzZ0rqqDj2yMOK39cSVSs' \
            '3S0XPuXe-6RzZxl3x3fsehCP_36IoqFVRbAUb7SqiBLtJiha5Dy_jfaXX5qSuf_mUo43FHJzYR0A8PspAgMBAAECggEBAIaZoHrN-gBn' \
            '9KGxBQUaH-dgj5fCHPOCcf6mJY0jUOEgTbx97DSEd8Ih6L3w4QBLGPBlp9N9z1qu0XWIriCYJMxLybFwWFfhTploOHB6mGPIrgPffhwZ' \
            'mfhIRY0ylH5GCUO2lG3z1NFMsaJJ3YZ3XXVD9b7KQhYMLRL3tUYFsRo0aOUgomHfAKXLOzriN5KY6I8iejBCnizvJSNejMfF3n7jZstH' \
            'zIjHGngxgV17Gn5p7l7mZIHh0ZXq-2-N2z3YW0ciqurlefMZlPkJ6JRHxFxxdIhA-osDVeFrUcEDTLArcgE1s2TKHsjt6-rLKQVP599R' \
            'KFMvfEguUP4Z64pbu5ECgYEAzmmT6PnGVd2B_EsA_Or3dD6qNaf7kOr6FfBh-mqre_U0Ot8HBY48F5qQ5-U9RCyxrGOYQtYuIpKMDVu4' \
            'vx5KiK9m-_ZGMo6ajHRZC8UgJfVb6GeSo81U41gYrG8g3KjAfYMlHh4nXKSL_M_4DEpDcqDehoaKh3a2fpGFNDK3NNsCgYEAwJm0AUNO' \
            'JVJg_U2ifkvRZibzAGMJo0frCjl8wGDxGgQByyq9B9lFbCe2Nsmz3kJZVmlnstUVfEH-LQT2_K4njUY68IK-HHnO1p6cmqwBE3he-TQC' \
            'r9tIX6Sy5kJ5DtJY1rmao378Lwt27X7ite5SA9vAb3UyuuCyD5Z1GDcOLUsCgYB6VPY1WHskfpBAL0-ZlcQsn8sO28zreWfYQsw-tqOF' \
            'ZrCax32I3GBe-NsypJkn43k1mx0tV3SmRsY8UITwuAoichoN8EpwQjX0UixIHn9MH9tlpKSy8cmCp76Py5jlThovCN-htutLK7ZPkg4H' \
            'cqgAsrjPb8OAP2ovHx2b7wbHiwKBgBofftvA_kNvpfoVYpnQvMknNURzKmZ8JbQQUgxh2bHWo0ukM1lyLclapYtO1leqFiXzS_5kinJ9' \
            'HPWMO9fP40t1IB9pDFIeb2CKyODtvYOfivowBMFHc8yNMTqr_3F0NFqDeCb-3UOgQXQ7BpL4jSU61CIJ-mSAf4Y_uQgcx457AoGAaWG7' \
            'DjPgpczUEeltWLHFp3D11UHg2_7I-ka-89E-jUnrQ4F24QnWZh7AN7yhyPYid1aWu8Uq_KZFHSGnQOlJh66VK7ECYGJN2mRj6lSJepOq' \
            'oBH9PG-OGmYO_WkbqtxDjQFlb39d6_CzWM5wZ-LRZKTOdeLTLB1w_sUkiyzplDM'

SECRET = 'AAAAAAAAAAAAAAAAAAAAAA=='
ROBOT_UID = '2'
TVM_CLIENT_ID = '1'
BLACKBOX_CLIENT_ID = '2'


def parse_host(host_str, parser):
    split = unicode(host_str).strip().split(':')
    if len(split) > 2:
        print 'Invalid host', host_str, '\n'

        parser.print_help()
        sys.exit(1)

    if len(split) == 1:
        return split[0], '80'

    return split[0], split[1]


def replace_hosts_in_config(config, hostmap, exclude_localhost=True):
    for key in config.iterkeys():
        if key.endswith('.host') or key.endswith('.uri') or key.endswith('_url'):
            if exclude_localhost and (config[key].startswith('http://localhost:') or config[key].startswith('localhost')):
                continue

            new_value = hostmap[config[key]]
            if not new_value:
                print 'Missing mapping for', key, config[key], hostmap
                sys.exit(1)

            config[key] = new_value


def replace_paths(text, dir):
    for rk, rv in REPLACE_PATHS.iteritems():
        if not os.path.exists(dir + rv):
            os.mkdir(dir + rv)

        text = text.replace(rk, dir + rv)

    return text


def replace_paths_in_file(file_path, dir):
    data = None
    with open(file_path, 'r') as fp:
        data = fp.read()

    if data:
        data = replace_paths(data, dir)
        with open(file_path, 'w') as fp:
            fp.write(data)

def print_config(config, output_file):
    with open(output_file, 'w') as output:
        for key, value in config.iteritems():
            output.write(key + '=' + value + '\n')

def parse_config(input_file):
    config = OrderedDict()
    with open(input_file, 'r') as inp:
        section = ''
        for line in inp:
            line = line.strip()
            if not line or line.startswith('#') or line.startswith('include('):
                continue
            if line.startswith('['):
                #section
                section = line.lstrip('[').rstrip(']')
            else:
                if '=' not in line:
                    print 'Bad line in config', line, input_file
                    sys.exit(1)

                split = line.split('=')
                key = split[0].strip()
                value = '='.join(split[1:]).strip()
                if section:
                    key = section + '.' + key

                value = value.strip()
                config[key] = value

    return config


def extract(archive_path, dest=None):
    print 'Extracting', archive_path
    if not archive_path.endswith('.gz'):
        print archive_path, 'not an archive, skipping extract'
        return

    args = ['tar', '-xzf', archive_path]
    if dest:
        args.append('-C')
        args.append(dest)

    if sp.call(args) != 0:
        print 'Failed to unpack', archive_path
        exit(1)


def download_file(url, name=None):
    if name:
        args = ['wget', '-q', '-O', name, url]
    else:
        args = ['wget', '-q', url]

    retcode = sp.call(args)
    if retcode != 0:
        print 'Failed to get', name, 'to', os.path.abspath(name), url, 'code', retcode
        exit(retcode)


def sandbox_download(resource, name=None):
    if resource in SANDBOX_CACHE:
        print 'From Sandbox cache', resource, 'to', SANDBOX_CACHE[resource], os.path.abspath(name)
        if os.path.exists(os.path.abspath(name)):
            os.remove(os.path.abspath(name))

        os.symlink(SANDBOX_CACHE[resource], os.path.abspath(name))
        return name

    print 'Downloading', resource, 'to', name
    download_file(SANDBOX_URL.format(resource_id=resource), name)

    SANDBOX_CACHE[resource] = os.path.abspath(name)
    print 'Caching', resource, 'to', SANDBOX_CACHE[resource]
    return name


def task_resources(task_id):
    response = sandbox_session.get(SANDBOX_RESOURCE_API.format(task_id=task_id), verify=False)
    data = response.json()
    for item in data['items']:
        yield item["id"], item['type']


def resource_id_by_task(task_id, resource_type):
    response = sandbox_session.get(SANDBOX_RESOURCE_API.format(task_id=task_id), verify=False)
    data = response.json()
    for item in data['items']:
        if item['type'].lower() == resource_type.lower():
            return item["id"]


def load_instancectl(path):
    for (rid, rtype) in task_resources(INSTANCECTL_TASK):
        file_name = sandbox_download(rid, os.path.join(path, rtype.lower()))
        os.chmod(file_name, 0777)

    os.symlink(os.path.join(path, 'instancectl.conf'), os.path.join(path, 'loop.conf'))


class TerminationHandler(object):
    def __init__(self, services):
        self.services = services
        signal.signal(signal.SIGTERM, self.handler)

    def handler(self, signum, frame):
        for s in self.services:
            if s.service_process:
                s.service_process.kill()


class TvmStaticServer(SocketServer.ThreadingMixIn, SocketServer.TCPServer):
    pass


class TvmStaticHandler(SimpleHTTPRequestHandler):
    TVM2_KEYS = None

    def do_handle(self):
        content_type = 'text/html'
        if unicode(self.path).startswith('/2/keys/?'):
            if not TvmStaticHandler.TVM2_KEYS:
                with open('tvm2_keys', 'r') as tvm2keys_fd:
                    TvmStaticHandler.TVM2_KEYS = tvm2keys_fd.read()

            response_text = TvmStaticHandler.TVM2_KEYS
        elif unicode(self.path).startswith('/2/ticket'):
            content_type = 'application / json'
            response_text = "{\"" + BLACKBOX_CLIENT_ID + "\":{\"ticket\":\"here the ticket\"}}"
        elif unicode(self.path).startswith('/ticket'):
            response_text = '1:' + SECRET
        else:
            self.send_response(404)
            return

        self.send_response(200)
        self.send_header('Content-type', content_type)
        self.end_headers()
        self.wfile.write(response_text)

    def do_GET(self):
        self.do_handle()

    def do_POST(self):
        self.do_handle()


class ServiceResource(object):
    pass


class MailSearchService(object):
    def __init__(self, nanny_service, port, name=None):
        self.name = nanny_service if not name else name
        self.nanny_service = nanny_service
        self.port = port
        self.dir = os.path.join(os.getcwd(), self.name)
        self.service_process = None
        self.extract = False

        if os.path.exists(self.dir):
            print 'Removing', os.path.abspath(self.dir)
            shutil.rmtree(self.dir)

        os.mkdir(self.dir)
        self.resources = {'sandbox': [], 'url': [], 'static': []}
        self.gather_resources()

    def name(self):
        return self.name

    def path(self, path):
        return os.path.join(self.dir, path)

    def cpu_limit(self):
        return '3.000000c'

    def memory_limit(self):
        return '1100000000'

    def dump_json(self):
        return {
            'properties': self.envs(),
            'configurationId': self.name + '#' + self.name + '-' + datetime.datetime.now().strftime('%s'),
            'container': {'constraints': {'memory_guarantee': self.memory_limit(), 'cpu_limit': self.cpu_limit()}}
        }

    def remove_searchmaps(self):
        gemaprev = os.path.join(self.dir, 'getmap_rev.py')
        if os.path.exists(gemaprev):
            with open(gemaprev, 'w') as getrev:
                getrev.write('#!/usr/bin/env python\n')
                getrev.write('print "empty getrev"')

        gensearchmap = os.path.join(self.dir, 'generateSearchMap.sh')
        if os.path.exists(gensearchmap):
            with open(gensearchmap, 'w') as genSmp:
                genSmp.write('#!/bin/bash\n')
                genSmp.write('exit 0')

    def gather_resources(self):
        headers = {'Authorization': 'OAuth ' + os.environ['NANNY_OAUTH_KEY']}

        response = nanny_session.get(
            NANNY_URL.format(service_id=self.nanny_service),
            headers=headers,
            verify=False)

        if response.status_code != 200:
            raise RuntimeError(
                'Can not load files for service {service} code is {code} body {body}'
                .format(service=self.nanny_service, code=response.status_code, body=response.content))

        data = response.json()
        service_resources = data['content']['resources']
        sandbox_files = service_resources['sandbox_files']

        for sf in sandbox_files:
            if sf['resource_type'] not in SANDBOX_IGNORE:
                if 'resource_id' in sf:
                    resource_id = sf['resource_id']
                else:
                    resource_id = resource_id_by_task(sf['task_id'], sf['resource_type'])

                sb_res = ServiceResource()
                sb_res.resource_id = resource_id
                sb_res.local_path = sf['local_path']

                self.resources['sandbox'].append(sb_res)

        for static_file in service_resources['static_files']:
            sb_res = ServiceResource()
            sb_res.content = static_file['content']
            sb_res.local_path = static_file['local_path']

            self.resources['static'].append(sb_res)

        for url_file in service_resources['url_files']:
            if unicode(url_file['url']).startswith('http'):
                sb_res = ServiceResource()
                sb_res.url = url_file['url']
                sb_res.local_path = url_file['local_path']

                self.resources['url'].append(sb_res)

    def load(self):
        for sf in self.resources['sandbox']:
            local_path = self.path(sf.local_path)
            sandbox_download(sf.resource_id, local_path)
            if self.extract:
                extract(local_path, self.dir)

            if unicode(local_path).endswith('-bundle.tar.gz'):
                bundle_path = local_path[:-7]
                if not os.path.exists(bundle_path):
                    continue

                for file_name in os.listdir(bundle_path):
                    file_path = self.path(file_name)
                    if unicode(file_name).endswith('.conf'):
                        replace_paths_in_file(file_path, self.dir)

        for static_file in self.resources['static']:
            local_path = self.path(static_file.local_path)
            with open(local_path, 'w') as out:
                config = replace_paths(static_file.content, self.dir)
                out.write(config.encode('utf-8'))

            os.chmod(local_path, 0777)

        for url_file in self.resources['url']:
            download_file(url_file.url, self.path(url_file.local_path))

        with open(self.path('dump.json'), 'w') as dump:
            json.dump(self.dump_json(), dump, indent=4)

        load_instancectl(self.dir)
        self.adjust_memory('Xmn', XMN)
        self.adjust_memory('Xms', XMS)
        self.adjust_memory('Xmx', XMX)
        self.remove_searchmaps()

    def run(self):
        self.service_process = sp.Popen(['./instancectl', 'start'], env=self.envs())
        print 'Launched', self.nanny_service, self.name, 'PID', self.service_process.pid

    def envs(self):
        envs = {
            'BSCONFIG_IHOST': 'localhost',
            'BSCONFIG_IPORT': str(self.port),
            'BSCONFIG_ITAGS': '""',
            'BSCONFIG_INAME': 'localhost:' + str(self.port),
            'BSCONFIG_IDIR': str(self.dir),
            'ROBOT_KEY': ROBOT_KEY,
            'ROBOT_UID': ROBOT_UID,
            'BLACKBOX_CLIENT_ID': BLACKBOX_CLIENT_ID,
            'TVM_API_HOST': 'localhost:17000',
            'SECRET': SECRET}

        if 'HOSTALIASES' in os.environ:
            envs['HOSTALIASES'] = os.environ['HOSTALIASES']

        return envs

    def init_service(self):
        self.load()
        self.prepare()

    def prepare(self):
        pass

    def adjust_memory(self, param, value):
        if sp.call(['sed', '-i', 's/' + param + '[0-9]*[mbgMBG]*/' + param + value + '/g', self.path('instancectl.conf')]) != 0:
            print 'Failed to modify', param, ' in instancectl.conf for', self.name
            exit(1)

        if sp.call(['sed', '-i', 's/{maxmemory}//g', self.path('instancectl.conf')]) != 0:
            print 'Failed to modify maxmemory ', param, ' in instancectl.conf for', self.name
            exit(1)

    def start_service(self):
        cwd = os.getcwd()
        os.chdir(self.dir)
        self.run()
        os.chdir(cwd)
