#!/usr/bin/python

from optparse import OptionParser
from mail_search_mock_utils import *


class Tupita(MailSearchService):
    def __init__(self, port, hostmap, lenulka, tikaite_port):
        MailSearchService.__init__(self, 'mail_search_tupita', port)
        self.hostmap = hostmap
        self.lenulka = lenulka
        self.tikaite_port = tikaite_port
        self.extract = True

    def prepare(self):
        with open(self.path('tikaite.conf'), 'w') as tikaite_config:
            tikaite_config.write(
                "log.level.min = all\nserver.port = 0\nserver.workers.min = 2\n"
                + "access_log.file=" + self.path("tikaite-access.log") + '\n'
                + "full_log.file=" + self.path("tikaite-full.log") + '\n'
                + "server.workers.percent = 50\nserver.connections = 50\n"
                + "server.timeout = 5000\nstorage.timeout = 5000\n"
                + "storage.connections = 100\nstorage.host = " + self.lenulka[0]
                + "\nstorage.port = " + self.lenulka[1] + '\n')

        tupita_config_path = self.path('tupita-bundle/tupita-prod.conf')
        lucene_config_path = self.path('lucene-mail-config-bundle/tupita-lucene.conf')
        replace_paths_in_file(tupita_config_path, self.dir)
        replace_paths_in_file(lucene_config_path, self.dir)

        tupita_config = parse_config(tupita_config_path)
        replace_hosts_in_config(tupita_config, self.hostmap)
        print_config(tupita_config, self.path('tupita-prod.conf'))

        for config in os.listdir(self.path('lucene-mail-config-bundle')):
            src = self.path('lucene-mail-config-bundle/' + config)
            dst = self.path(config)
            if os.path.isfile(src):
                shutil.copy(src, dst)
            else:
                shutil.copytree(src, dst)

        if sp.call(['sed', '-i', 's/tupita-bundle\/tupita-prod.conf/tupita-prod.conf/g', self.path('instancectl.conf')]) != 0:
            print 'Failed replace config in instancectl'
            exit(1)

        if sp.call(['sed', '-i', 's/lucene-mail-config-bundle\/tupita-lucene.conf/tupita-lucene.conf/g', self.path('instancectl.conf')]) != 0:
            print 'Failed replace config in instancectl'
            exit(1)


if __name__ == '__main__':
    parser = OptionParser()
    parser.add_option("-w", "--work-dir", dest="workdir", help="working directory", default=os.getcwd())
    parser.add_option("-p", "--bind-port", dest="bindport", default=0, help="Start port allowed to bind", type=int)
    parser.add_option("-l", "--lenulka", dest="storage", default=0, help="Lenulka host:port")

    (options, args) = parser.parse_args()

    if 'NANNY_OAUTH_KEY' not in os.environ:
        print 'Missing NANNY_OAUTH_KEY eviroment variable'
        sys.exit(1)

    if not os.path.isdir(options.workdir):
        print 'Supplied working directory is not a directory'
        parser.print_help()
        exit(1)

    os.chdir(os.path.abspath(options.workdir))

    lenulka = parse_host(options.storage, parser)

    tvm_port = options.bindport + 10
    tikaite_port = options.bindport + 11
    tvm_server = TvmStaticServer(("", tvm_port), TvmStaticHandler)

    hostmap = {'https://tvm-api.yandex.net': 'localhost:' + str(tvm_port),
               'tikaite.ape.yandex.net': 'localhost:' + str(tikaite_port)}

    tupita = Tupita(options.bindport, hostmap, lenulka, tikaite_port)
    tupita.init_service()
    print 'Starting tupita'
    tupita.start_service()

    signal_handler = TerminationHandler([tupita])
    tvm_server.serve_forever()
