package ru.yandex.search.mop.manager.config;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractMopManagerConfigBuilder
    <T extends AbstractMopManagerConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements MopManagerConfig
{
    private int interval;
    private String file;
    private String searchPortName;
    private String indexPortName;
    private Set<String> scopes;
    private boolean pumpkin;

    protected AbstractMopManagerConfigBuilder(final MopManagerConfig config) {
        super(config);
        interval = config.interval();
        file = config.file();
        searchPortName = config.searchPortName();
        indexPortName = config.indexPortName();
        scopes = new LinkedHashSet<>(config.scopes());
        pumpkin = config.pumpkin();
    }

    protected AbstractMopManagerConfigBuilder(
        final IniConfig config,
        final MopManagerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        interval = config.getIntegerDuration("interval", defaults.interval());
        file = config.getString("file", defaults.file());
        searchPortName = config.getString("search-port-name");
        indexPortName = config.getString("index-port-name");
        scopes = config.get(
            "scopes",
            defaults.scopes(),
            new CollectionParser<>(NonEmptyValidator.TRIMMED, LinkedHashSet::new));
        pumpkin = config.getBoolean("pumpkin", defaults.pumpkin());
    }

    @Override
    public int interval() {
        return interval;
    }

    public T interval(final int interval) {
        this.interval = interval;
        return self();
    }

    @Override
    public String searchPortName() {
        return searchPortName;
    }

    public T searchPortName(final String searchPortName) {
        this.searchPortName = searchPortName;
        return self();
    }

    @Override
    public String indexPortName() {
        return indexPortName;
    }

    public T indexPortName(final String indexPortName) {
        this.indexPortName = indexPortName;
        return self();
    }

    @Override
    public String file() {
        return file;
    }

    public T file(final String file) {
        this.file = file;
        return self();
    }

    @Override
    public Set<String> scopes() {
        return scopes;
    }

    public T scopes(final Set<String> scopes) {
        this.scopes = new LinkedHashSet<>(scopes);
        return self();
    }

    @Override
    public boolean pumpkin() {
        return pumpkin;
    }

    public T pumpkin(final boolean pumpkin) {
        this.pumpkin = pumpkin;
        return self();
    }
}

