package ru.yandex.search.mop.manager.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMopManagerConfig
    extends ImmutableHttpHostConfig
    implements MopManagerConfig
{
    private final int interval;
    private final String file;
    private final String searchPortName;
    private final String indexPortName;
    private final Set<String> scopes;
    private final boolean pumpkin;

    public ImmutableMopManagerConfig(final MopManagerConfig config)
        throws ConfigException
    {
        super(config);
        interval = config.interval();
        file = config.file();
        searchPortName = config.searchPortName();
        indexPortName = config.indexPortName();
        scopes = Collections.unmodifiableSet(new LinkedHashSet<>(config.scopes()));
        pumpkin = config.pumpkin();
    }

    @Override
    public int interval() {
        return interval;
    }

    @Override
    public String file() {
        return file;
    }

    @Override
    public String searchPortName() {
        return searchPortName;
    }

    @Override
    public String indexPortName() {
        return indexPortName;
    }

    @Override
    public Set<String> scopes() {
        return scopes;
    }

    @Override
    public boolean pumpkin() {
        return pumpkin;
    }
}

