package ru.yandex.search.mop.manager.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MopManagerConfigBuilder
    extends AbstractMopManagerConfigBuilder<MopManagerConfigBuilder>
{
    public MopManagerConfigBuilder() {
        this(MopManagerConfigDefaults.INSTANCE);
    }

    public MopManagerConfigBuilder(final MopManagerConfig config) {
        super(config);
    }

    public MopManagerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, MopManagerConfigDefaults.INSTANCE);
    }

    public MopManagerConfigBuilder(
        final IniConfig config,
        final MopManagerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public MopManagerConfigBuilder self() {
        return this;
    }

    public ImmutableMopManagerConfig build() throws ConfigException {
        return new ImmutableMopManagerConfig(this);
    }
}
