package ru.yandex.search.mop.manager.config;

import java.util.Collections;
import java.util.Set;

import ru.yandex.http.config.HttpHostConfigDefaults;

public class MopManagerConfigDefaults
    extends HttpHostConfigDefaults
    implements MopManagerConfig
{
    public static final MopManagerConfigDefaults INSTANCE =
        new MopManagerConfigDefaults();

    private static final int DEFAULT_INTERVAL = 60000;
    private static final String DEFAULT_FILE_NAME = "searchmap.json";

    protected MopManagerConfigDefaults() {
    }

    @Override
    public int interval() {
        return DEFAULT_INTERVAL;
    }

    @Override
    public String file() {
        return DEFAULT_FILE_NAME;
    }

    @Override
    public String searchPortName() {
        return null;
    }

    @Override
    public String indexPortName() {
        return null;
    }

    @Override
    public Set<String> scopes() {
        return Collections.emptySet();
    }

    @Override
    public boolean pumpkin() {
        return false;
    }
}
