package ru.yandex.search.mop.common.searchmap;

import java.util.Objects;

import ru.yandex.search.mop.common.services.ServiceConfig;

public class BackendHost {
    private final String hostname;
    private final int searchPort;
    private final int searchPortNg;
    private final int indexPort;
    private final int dumpPort;
    private final int queueIdPort;
    private final boolean freshness;
    private final String dc;

    private final int hashCode;

    public BackendHost(
        final String hostname,
        final int searchPort,
        final int searchPortNg,
        final int indexPort,
        final int dumpPort,
        final int queueIdPort,
        final boolean freshness,
        final String dc)
    {
        this.hostname = hostname;
        this.searchPort = searchPort;
        this.searchPortNg = searchPortNg;
        this.indexPort = indexPort;
        this.dumpPort = dumpPort;
        this.queueIdPort = queueIdPort;
        this.freshness = freshness;
        this.dc = dc;
        this.hashCode = generateHashCode();
    }

    public BackendHost(
        final String hostname,
        final int searchPort,
        final int searchPortNg,
        final int indexPort,
        final int dumpPort,
        final int queueIdPort)
    {
        this(
            hostname,
            searchPort,
            searchPortNg,
            indexPort,
            dumpPort,
            queueIdPort,
            true,
            null);
    }

    public BackendHost(
        final String hostname,
        final String dc,
        final int basePort,
        final ServiceConfig config)
    {
        this(hostname,
            basePort + config.searchPortOffset(),
            basePort + config.searchPortNgOffset(),
            basePort + config.indexPortOffset(),
            basePort + config.dumpPortOffset(),
            basePort + config.queueIdPortOffset(),
            true,
            dc);
    }

    public String hostname() {
        return hostname;
    }

    public int searchPort() {
        return searchPort;
    }

    public int searchPortNg() {
        return searchPortNg;
    }

    public int indexPort() {
        return indexPort;
    }

    public int dumpPort() {
        return dumpPort;
    }

    public int queueIdPort() {
        return queueIdPort;
    }

    public boolean freshness() {
        return freshness;
    }

    public String dc() {
        return dc;
    }

    @Override
    public String toString() {
        return "BackendHost{" +
            "hostname='" + hostname + '\'' +
            ", searchPort=" + searchPort +
            ", searchPortNg=" + searchPortNg +
            ", indexPort=" + indexPort +
            ", dumpPort=" + dumpPort +
            ", queueIdPort=" + queueIdPort +
            ", freshness=" + freshness +
            ", dc=" + dc +
            ", hashCode=" + hashCode +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BackendHost host = (BackendHost) o;
        return Objects.equals(hostname, host.hostname)
            && Objects.equals(dc, host.dc)
            && searchPort == host.searchPort
            && searchPortNg == host.searchPortNg
            && indexPort == host.indexPort
            && dumpPort == host.dumpPort
            && queueIdPort == host.queueIdPort
            && freshness == host.freshness;
    }

    public int generateHashCode() {
        int result = hostname.hashCode();
        result = 31 * result + searchPort;
        result = 31 * result + searchPortNg;
        result = 31 * result + indexPort;
        result = 31 * result + dumpPort;
        result = 31 * result + queueIdPort;
        result = 31 * result + (freshness ? 1 : 0);
        return result;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }
}
