package ru.yandex.search.mop.common.searchmap;

import java.util.Set;

public class HostGroup {
    private final int id;
    private final Set<BackendHost> hosts;

    public HostGroup(final int id, final Set<BackendHost> hosts) {
        this.id = id;
        this.hosts = hosts;
    }

    public int id() {
        return id;
    }

    public Set<BackendHost> hosts() {
        return hosts;
    }

    @Override
    public String toString() {
        return "HostGroup{" +
            "id=" + id +
            ", hosts=" + hosts +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        HostGroup hostGroup = (HostGroup) o;

        if (id != hostGroup.id) return false;
        return hosts.equals(hostGroup.hosts);
    }

    @Override
    public int hashCode() {
        return 31 * id + hosts.hashCode();
    }
}
