package ru.yandex.search.mop.common.searchmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import ru.yandex.search.mop.common.services.Service;

public class Metashard {
    private final int label;
    private final Service service;
    private int queueId;
    private int hostGroupId;
    private ShardsRange shardsRange;

    public Metashard(
        final int label,
        final Service service,
        final int queueId,
        final int hostGroupId,
        final ShardsRange shardsRange)
    {
        this.label = label;
        this.service = service;
        this.queueId = queueId;
        this.hostGroupId = hostGroupId;
        this.shardsRange = shardsRange;
    }

    public Metashard(
        final int label,
        final Service service,
        final int queueId,
        final int hostGroupId,
        final int shardsRangeStart,
        final int shardsRangeEnd)
    {
        this(label,
            service,
            queueId,
            hostGroupId,
            new ShardsRange(shardsRangeStart, shardsRangeEnd));
    }

    public int label() {
        return label;
    }

    public Service service() {
        return service;
    }

    public int queueId() {
        return queueId;
    }

    public void queueId(final int queueId) {
        this.queueId = queueId;
    }

    public int hostGroupId() {
        return hostGroupId;
    }

    public void hostGroupId(final int hostGroupId) {
        this.hostGroupId = hostGroupId;
    }

    public ShardsRange shardsRange() {
        return shardsRange;
    }

    public static List<ShardsRange> generateShardsRanges(
        final List<Integer> shards)
    {
        List<ShardsRange> ranges = new ArrayList<>();
        if (shards.isEmpty()) {
            return ranges;
        }
        Collections.sort(shards);
        int start = shards.get(0);
        for(int i = 1; i < shards.size(); i++) {
            int cur = shards.get(i);
            int prev = shards.get(i - 1);
            if (cur == prev + 1 || cur == prev) {
                continue;
            }
            ranges.add(new ShardsRange(start, prev));
            start = cur;
        }
        ranges.add(new ShardsRange(start, shards.get(shards.size() - 1)));
        return ranges;
    }

    @Override
    public String toString() {
        return "Metashard{" +
            "label=" + label +
            ", service=" + service +
            ", queueId=" + queueId +
            ", hostGroupId=" + hostGroupId +
            ", shardsRange=" + shardsRange +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Metashard metashard = (Metashard) o;

        return label == metashard.label
            && queueId == metashard.queueId
            && hostGroupId == metashard.hostGroupId
            && service == metashard.service
            && Objects.equals(shardsRange, metashard.shardsRange);
    }

    @Override
    public int hashCode() {
        int result = label;
        result = 31 * result + service.hashCode();
        result = 31 * result + queueId;
        result = 31 * result + hostGroupId;
        result = 31 * result + (shardsRange != null ? shardsRange.hashCode() : 0);
        return result;
    }
}
