package ru.yandex.search.mop.common.searchmap;

import java.util.Comparator;
import java.util.List;

public class Queue {
    private final int id;
    private final List<QueueHost> hosts;
    private final String queueStr;

    public Queue(final int id, final List<QueueHost> hosts) {
        this.id = id;
        this.hosts = hosts;
        this.hosts.sort(Comparator.comparing(QueueHost::hostname));
        StringBuilder sb = new StringBuilder();
        for (QueueHost host: hosts) {
            sb.append(host.hostStr()).append('|');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        this.queueStr = sb.toString();
    }

    public int id() {
        return id;
    }

    public List<QueueHost> hosts() {
        return hosts;
    }

    public String queueStr() {
        return queueStr;
    }

    @Override
    public String toString() {
        return "Queue{" + "id=" + id + ", hosts=" + queueStr + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Queue queue = (Queue) o;
        return queueStr.equals(queue.queueStr);
    }

    @Override
    public int hashCode() {
        return 31 * id + queueStr.hashCode();
    }
}
