package ru.yandex.search.mop.common.searchmap;

public class QueueHost {
    private final String hostname;
    private final int zkPort;
    private final int httpPort;
    private final String hostStr;

    public QueueHost(
        final String hostname,
        final int zkPort,
        final int httpPort)
    {
        this.hostname = hostname;
        this.zkPort = zkPort;
        this.httpPort = httpPort;
        this.hostStr = hostname + ':' + zkPort + '/' + httpPort;
    }

    public String hostname() {
        return hostname;
    }

    public int zkPort() {
        return zkPort;
    }

    public int httpPort() {
        return httpPort;
    }

    public String hostStr() {
        return hostStr;
    }
}
