package ru.yandex.search.mop.common.searchmap;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import ru.yandex.http.util.NotFoundException;
import ru.yandex.search.mop.common.services.ServiceScope;

public class SearchMap {
    protected volatile long version;
    protected final List<Queue> queues;
    protected final List<HostGroup> hostGroups;
    protected final List<Metashard> metashards;

    public SearchMap(
        final long version,
        final List<Queue> queues,
        final List<HostGroup> hostGroups,
        final List<Metashard> metashards)
    {
        this.version = version;
        this.queues = queues;
        this.hostGroups = hostGroups;
        this.metashards = metashards;
    }

    public long version() {
        return version;
    }

    public List<Queue> queues() {
        return queues;
    }

    public List<HostGroup> hostGroups() {
        return hostGroups;
    }

    public Set<BackendHost> hosts(final int hostGroupId)
        throws NotFoundException
    {
        HostGroup hostGroup = hostGroups.get(hostGroupId);
        if (hostGroup == null) {
            throw new NotFoundException(
                "Host group not found: " + hostGroupId);
        }
        return hostGroup.hosts();
    }

    public List<Metashard> metashards() {
        return metashards;
    }

    public SearchMap getPartByScope(ServiceScope scope) {
        List<Metashard> scopeMetashards = new ArrayList<>();
        for (Metashard metashard: metashards) {
            if (scope.services().contains(metashard.service())) {
                scopeMetashards.add(metashard);
            }
        }
        return new SearchMap(version, queues, hostGroups, scopeMetashards);
    }

    @Override
    public String toString() {
        return "SearchMap{" +
            "version=" + version +
            ", queues=" + queues +
            ", hostGroups=" + hostGroups +
            ", metashards=" + metashards +
            '}';
    }
}
