package ru.yandex.search.mop.common.services;

import java.util.Locale;

public enum Service {
    ABOOK(
        ServiceConfig.ABOOK_CONFIG),
    CHANGE_LOG(
        ServiceConfig.CHANGE_LOG_CONFIG),
    CHANGE_LOG_OFFLINE(
        ServiceConfig.CHANGE_LOG_OFFLINE_CONFIG),
    IEX(
        ServiceConfig.IEX_CONFIG),
    SUBSCRIPTIONS_PROD_1(
        ServiceConfig.SUBSCRIPTIONS_PROD_1_CONFIG),
    SUBSCRIPTIONS_PROD_2(
        ServiceConfig.SUBSCRIPTIONS_PROD_2_CONFIG),
    CORP_CHANGE_LOG(
        ServiceConfig.CORP_CHANGE_LOG_CONFIG),
    CORP_CHANGE_LOG_OFFLINE(
        ServiceConfig.CORP_CHANGE_LOG_OFFLINE_CONFIG),
    THE_MESSENGER(
        ServiceConfig.THE_MESSENGER_CONFIG),
    DISK_QUEUE(
        ServiceConfig.DISK_QUEUE_CONFIG),
    DISK_QUEUE_OFFLINE(
        ServiceConfig.DISK_QUEUE_OFFLINE_CONFIG),
    PHOTOSLICE(
        ServiceConfig.PHOTOSLICE_CONFIG),
    IPDD(
        ServiceConfig.IPDD_CONFIG);

    final String lowName;
    final ServiceConfig config;

    Service(final ServiceConfig config) {
        this.lowName = name().toLowerCase(Locale.ROOT);
        this.config = config;
    }

    public String lowName() {
        return lowName;
    }

    public ServiceConfig config() {
        return config;
    }
}
