package ru.yandex.search.mop.common.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ServiceConfig {
    public static final ServiceConfig ABOOK_CONFIG;
    public static final ServiceConfig CHANGE_LOG_CONFIG;
    public static final ServiceConfig CHANGE_LOG_OFFLINE_CONFIG;
    public static final ServiceConfig IEX_CONFIG;
    public static final ServiceConfig SUBSCRIPTIONS_PROD_1_CONFIG;
    public static final ServiceConfig SUBSCRIPTIONS_PROD_2_CONFIG;
    public static final ServiceConfig CORP_CHANGE_LOG_CONFIG;
    public static final ServiceConfig CORP_CHANGE_LOG_OFFLINE_CONFIG;
    public static final ServiceConfig THE_MESSENGER_CONFIG;
    public static final ServiceConfig DISK_QUEUE_CONFIG;
    public static final ServiceConfig DISK_QUEUE_OFFLINE_CONFIG;
    public static final ServiceConfig PHOTOSLICE_CONFIG;
    public static final ServiceConfig IPDD_CONFIG;

    private final int searchPortOffset;
    private final int searchPortNgOffset;
    private final int indexPortOffset;
    private final int dumpPortOffset;
    private final int queueIdPortOffset;

    static {
        try (BufferedReader reader =
            new BufferedReader(
                new InputStreamReader(
                    ServiceConfig.class.getResourceAsStream("services.conf"),
                    StandardCharsets.UTF_8)))
        {
            IniConfig config = new IniConfig(reader);
            ABOOK_CONFIG =
                new ServiceConfig(config.section("abook"));
            IEX_CONFIG =
                new ServiceConfig(config.section("iex"));
            CHANGE_LOG_CONFIG =
                new ServiceConfig(config.section("change_log"));
            CHANGE_LOG_OFFLINE_CONFIG =
                new ServiceConfig(config.section("change_log_offline"));
            SUBSCRIPTIONS_PROD_1_CONFIG =
                new ServiceConfig(config.section("subscriptions_prod_1"));
            SUBSCRIPTIONS_PROD_2_CONFIG =
                new ServiceConfig(config.section("subscriptions_prod_2"));
            CORP_CHANGE_LOG_CONFIG =
                new ServiceConfig(config.section("corp_change_log"));
            CORP_CHANGE_LOG_OFFLINE_CONFIG =
                new ServiceConfig(config.section("corp_change_log_offline"));
            THE_MESSENGER_CONFIG =
                new ServiceConfig(config.section("the_messenger"));
            DISK_QUEUE_CONFIG =
                new ServiceConfig(config.section("disk_queue"));
            DISK_QUEUE_OFFLINE_CONFIG =
                new ServiceConfig(config.section("disk_queue_offline"));
            PHOTOSLICE_CONFIG =
                new ServiceConfig(config.section("photoslice"));
            IPDD_CONFIG =
                new ServiceConfig(config.section("ipdd"));
        } catch (IOException | ConfigException e) {
            throw new RuntimeException("Service config initialization failed", e);
        }
    }

    private ServiceConfig(final IniConfig config) throws ConfigException {
        this.searchPortOffset = config.getInt("search-port-offset");
        this.searchPortNgOffset = config.getInt("search-port-ng-offset");
        this.indexPortOffset = config.getInt("index-port-offset");
        this.dumpPortOffset = config.getInt("dump-port-offset");
        this.queueIdPortOffset = config.getInt("queue-id-port-offset");
    }

    public int searchPortOffset() {
        return searchPortOffset;
    }

    public int searchPortNgOffset() {
        return searchPortNgOffset;
    }

    public int indexPortOffset() {
        return indexPortOffset;
    }

    public int dumpPortOffset() {
        return dumpPortOffset;
    }

    public int queueIdPortOffset() {
        return queueIdPortOffset;
    }

    @Override
    public String toString() {
        return "ServiceConfig{" +
            "searchPortOffset=" + searchPortOffset +
            ", searchPortNgOffset=" + searchPortNgOffset +
            ", indexPortOffset=" + indexPortOffset +
            ", dumpPortOffset=" + dumpPortOffset +
            ", queueIdPortOffset=" + queueIdPortOffset +
            '}';
    }
}
