package ru.yandex.search.mop.common.services;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum ServiceScope {
    MAIL_BP(
        Service.CHANGE_LOG,
        Service.CHANGE_LOG_OFFLINE,
        Service.IEX,
        Service.SUBSCRIPTIONS_PROD_1,
        Service.SUBSCRIPTIONS_PROD_2),
    MAIL_CORP(
        Service.CORP_CHANGE_LOG,
        Service.CORP_CHANGE_LOG_OFFLINE),
    DISK(
        Service.DISK_QUEUE,
        Service.DISK_QUEUE_OFFLINE,
        Service.PHOTOSLICE),
    IPDD(
        Service.IPDD);

    final Set<Service> services;

    ServiceScope(Service... services) {
        this.services = new HashSet<>(services.length);
        this.services.addAll(Arrays.asList(services));
    }

    public Set<Service> services() {
        return services;
    }

    public boolean contains(final Service service) {
        return services.contains(service);
    }
}
