#!/bin/bash
set -exo pipefail

source config.sh
source classpath.sh

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR

source gc_args.sh

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=mop_server \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.search.mop.server.MopServer mop_server.conf