package ru.yandex.search.mop.server;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;

public class DeleteSearchHostsContext {
    private final PrefixedLogger logger;
    private final String host;

    public DeleteSearchHostsContext(
        final CgiParams params,
        final PrefixedLogger logger)
        throws BadRequestException
    {
        this.logger = logger;
        this.host = params.getString("host");
        if (this.host.isEmpty()) {
            throw new BadRequestException("Non-empty host required");
        }
    }

    public PrefixedLogger logger() {
        return logger;
    }

    public String host() {
        return host;
    }
}
