package ru.yandex.search.mop.server;

import java.sql.SQLException;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.search.mop.server.searchmap.ServerSearchMap;

public class DeleteSearchHostsHandler implements ProxyRequestHandler {
    private final MopServer mop;

    public DeleteSearchHostsHandler(final MopServer mop) {
        this.mop = mop;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        DeleteSearchHostsContext context =
            new DeleteSearchHostsContext(session.params(), session.logger());
        ServerSearchMap searchMap = mop.searchMapContainer().searchMap();

        mop.searchMapContainer().writeLock().lock();
        try {
            int version =
                mop.hostGroupDAO().deleteHostname(context.host());
            if (version > 0) {
                int deleted = searchMap.deleteHost(context.host(), version);
                context.logger().info(
                    "Hosts = '" + context.host() + "' deleted"
                    + "; number of deleted hosts in memory: " + deleted
                    + "; new searchmap version: " + searchMap.version());
                session.response(HttpStatus.SC_OK);
            } else if (version == 0) {
                context.logger().info("No host has been deleted");
                throw new NotFoundException(
                    "Hosts with hostname " + context.host() + " not found");
            } else {
                session.response(
                    HttpStatus.SC_INTERNAL_SERVER_ERROR,
                    new NStringEntity(
                        "Failed to update version",
                        ContentType.TEXT_PLAIN
                            .withCharset(session.acceptedCharset())));
            }
        } catch (SQLException e) {
            context.logger().log(Level.SEVERE, "Database error", e);
            session.response(
                HttpStatus.SC_INTERNAL_SERVER_ERROR,
                new NStringEntity(
                    e.getMessage(),
                    ContentType.TEXT_PLAIN
                        .withCharset(session.acceptedCharset())));
        } finally {
            mop.searchMapContainer().writeLock().unlock();
        }
    }
}
