package ru.yandex.search.mop.server;

import java.io.FileWriter;
import java.io.IOException;
import java.util.TimerTask;
import java.util.logging.Level;

import ru.yandex.http.util.NotFoundException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.mop.common.writers.SearchMapJsonWriter;

public class FlushSearchMapTask extends TimerTask {
    private final MopServer mop;

    public FlushSearchMapTask(final MopServer mop) {
        this.mop = mop;
    }

    @Override
    public void run() {
        try {
            writeSearchMapToFile();
            mop.logger().info("Flush searchmap task done");
        } catch (Throwable t) {
            mop.logger().log(Level.SEVERE, "Flush searchmap task error", t);
        }
    }

    public void writeSearchMapToFile() throws IOException, NotFoundException {
        try (FileWriter file = new FileWriter(mop.config().file())) {
            StringBuilderWriter sbw = SearchMapJsonWriter.INSTANCE.write(
                mop.searchMapContainer().searchMap(),
                JsonType.NORMAL);
            file.write(sbw.toString());
            file.flush();
        }
    }
}
