package ru.yandex.search.mop.server;

import org.apache.http.HttpException;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;

public class GetSearchMapContext {
    private final PrefixedLogger logger;
    private final String format;
    private final long version;

    public GetSearchMapContext(
        final CgiParams params,
        final PrefixedLogger logger)
        throws HttpException
    {
        this.logger = logger;
        this.format = params.getString("format", "string");
        this.version = params.getLong("version", -1L);
    }

    public String format() {
        return format;
    }

    public PrefixedLogger logger() {
        return logger;
    }

    public long version() {
        return version;
    }
}
