package ru.yandex.search.mop.server;

import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.ServerException;
import ru.yandex.search.mop.common.searchmap.SearchMap;
import ru.yandex.search.mop.common.writers.SearchMapJsonWriter;
import ru.yandex.search.mop.common.writers.SearchMapStringWriter;
import ru.yandex.search.mop.common.writers.SearchMapWriter;

public class GetSearchMapHandler implements ProxyRequestHandler {
    private static final String EMPTY_JSON = "{}";
    private static final String EMPTY_STRING = "";

    private final MopServer mop;

    public GetSearchMapHandler(final MopServer mop) {
        this.mop = mop;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        final GetSearchMapContext context =
            new GetSearchMapContext(session.params(), session.logger());
        SearchMapWriter writer;
        ContentType contentType;
        String emptyBody;
        if (context.format().equals("json")) {
            writer = SearchMapJsonWriter.INSTANCE;
            contentType = ContentType.APPLICATION_JSON;
            emptyBody = EMPTY_JSON;
        } else {
            writer = SearchMapStringWriter.INSTANCE;
            contentType = ContentType.TEXT_PLAIN;
            emptyBody = EMPTY_STRING;
        }
        contentType = contentType.withCharset(session.acceptedCharset());
        try {
            String body;
            SearchMap searchMap = mop.searchMapContainer().searchMap();
            if (context.version() < searchMap.version()) {
                body = writer.write(searchMap).toString();
                mop.getSearchMapResponse(false);
            } else {
                body = emptyBody;
                mop.getSearchMapResponse(true);
            }
            session.response(
                HttpStatus.SC_OK,
                new NStringEntity(body, contentType));
        } catch (NotFoundException e) {
            context.logger().log(Level.SEVERE, "Not found exception", e);
            session.handleException(e);
        } catch (IOException e) {
            context.logger().log(Level.SEVERE, "Converting searchmap failed", e);
            session.handleException(
                new ServerException(HttpStatus.SC_INTERNAL_SERVER_ERROR, e));
        }
    }
}
