package ru.yandex.search.mop.server;

import java.util.Locale;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.mop.common.services.ServiceScope;

public class GetShardsForConsumeContext {
    private final PrefixedLogger logger;
    private final int label;
    private final String host;
    private final String dc;
    private final int port;
    private final ServiceScope scope;
    private final boolean full;

    public GetShardsForConsumeContext(
        final CgiParams params,
        final PrefixedLogger logger)
        throws BadRequestException
    {
        this.logger = logger;
        this.label = params.getInt("label");
        this.host = params.getString("host");
        this.dc = params.getString("dc");
        if (this.host.isEmpty()) {
            throw new BadRequestException("Non-empty host required");
        }
        this.port = params.getInt("port");
        this.full = params.getBoolean("full", false);
        String scopeStr = params.getString("scope").toUpperCase(Locale.ROOT);
        try {
            this.scope = ServiceScope.valueOf(scopeStr);
        } catch (IllegalArgumentException e) {
            throw new BadRequestException(
                "Failed to parse scope with value " + scopeStr);
        }
    }

    public PrefixedLogger logger() {
        return logger;
    }

    public int label() {
        return label;
    }

    public String host() {
        return host;
    }

    public String dc() {
        return dc;
    }

    public int port() {
        return port;
    }

    public boolean full() {
        return full;
    }

    public ServiceScope scope() {
        return scope;
    }
}
