package ru.yandex.search.mop.server;

import java.util.TimerTask;
import java.util.logging.Level;

import ru.yandex.search.mop.common.searchmap.SearchMap;

public class UpdateSearchMapTask extends TimerTask {
    private final MopServer mop;

    public UpdateSearchMapTask(final MopServer mop) {
        this.mop = mop;
    }

    @Override
    public void run() {
        try {
            long currentVersion = mop.searchMapContainer().searchMap().version();
            long version = mop.metashardDAO().getMaxVersion();
            if (version > currentVersion) {
                SearchMap searchMap = mop.searchMapDAO().getSearchMap();
                mop.searchMapContainer().searchMap(searchMap);
                mop.logger().info("Update searchmap task done, version: " + version);
            }
        } catch (Throwable t) {
            mop.logger().log(Level.SEVERE, "Update searchmap task error", t);
        }
    }
}
