package ru.yandex.search.mop.server.config;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.mop.server.config.database.DatabaseConfig;
import ru.yandex.search.mop.server.config.database.DatabaseConfigBuilder;

public abstract class AbstractMopServerConfigBuilder
    <T extends AbstractMopServerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements MopServerConfig
{
    private DatabaseConfigBuilder databaseConfig;
    private int interval;
    private String file;
    private boolean pumpkin;

    protected AbstractMopServerConfigBuilder(final MopServerConfig config) {
        super(config);
        interval = config.interval();
        file = config.file();
        pumpkin = config.pumpkin();
        databaseConfig(config.databaseConfig());
    }

    protected AbstractMopServerConfigBuilder(
        final IniConfig config,
        final MopServerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        interval = config.getIntegerDuration("interval", defaults.interval());
        file = config.getString("file", defaults.file());
        pumpkin = config.getBoolean("pumpkin", defaults.pumpkin());
        IniConfig databaseSection = config.section("database");
        if (databaseSection != null) {
            databaseConfig =
                new DatabaseConfigBuilder(
                    databaseSection,
                    defaults.databaseConfig());
        } else {
            throw new ConfigException("Database section is not set");
        }
    }

    @Override
    public int interval() {
        return interval;
    }

    public T interval(final int interval) {
        this.interval = interval;
        return self();
    }

    @Override
    public String file() {
        return file;
    }

    public T file(final String file) {
        this.file = file;
        return self();
    }

    @Override
    public boolean pumpkin() {
        return pumpkin;
    }

    public T pumpkin(final boolean pumpkin) {
        this.pumpkin = pumpkin;
        return self();
    }

    @Override
    public DatabaseConfigBuilder databaseConfig() {
        return databaseConfig;
    }

    public T databaseConfig(final DatabaseConfig databaseConfig) {
        this.databaseConfig = new DatabaseConfigBuilder(databaseConfig);
        return self();
    }
}

