package ru.yandex.search.mop.server.config;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.mop.server.config.database.DatabaseConfigBuilder;
import ru.yandex.search.mop.server.config.database.ImmutableDatabaseConfig;

public class ImmutableMopServerConfig
    extends ImmutableHttpProxyConfig
    implements MopServerConfig
{
    private final ImmutableDatabaseConfig databaseConfig;
    private final int interval;
    private final String file;
    private final boolean pumpkin;

    public ImmutableMopServerConfig(final MopServerConfig config)
        throws ConfigException
    {
        super(config);
        interval = config.interval();
        file = config.file();
        pumpkin = config.pumpkin();
        databaseConfig =
            new DatabaseConfigBuilder(config.databaseConfig()).build();
    }

    @Override
    public int interval() {
        return interval;
    }

    @Override
    public String file() {
        return file;
    }

    @Override
    public boolean pumpkin() {
        return pumpkin;
    }

    @Override
    public ImmutableDatabaseConfig databaseConfig() {
        return databaseConfig;
    }
}

