package ru.yandex.search.mop.server.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MopServerConfigBuilder
    extends AbstractMopServerConfigBuilder<MopServerConfigBuilder>
{
    public MopServerConfigBuilder() {
        this(MopServerConfigDefaults.INSTANCE);
    }

    public MopServerConfigBuilder(final MopServerConfig config) {
        super(config);
    }

    public MopServerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, MopServerConfigDefaults.INSTANCE);
    }

    public MopServerConfigBuilder(
        final IniConfig config,
        final MopServerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public MopServerConfigBuilder self() {
        return this;
    }

    public ImmutableMopServerConfig build() throws ConfigException {
        return new ImmutableMopServerConfig(this);
    }
}
