package ru.yandex.search.mop.server.config;

import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.search.mop.server.config.database.DatabaseConfig;
import ru.yandex.search.mop.server.config.database.DatabaseConfigDefaults;

public class MopServerConfigDefaults
    extends HttpProxyConfigDefaults
    implements MopServerConfig
{
    public static final MopServerConfigDefaults INSTANCE =
        new MopServerConfigDefaults();

    private static final int DEFAULT_INTERVAL = 600000;
    private static final String DEFAULT_FILE_NAME = "/data/searchmap.json";

    protected MopServerConfigDefaults() {
    }

    @Override
    public int interval() {
        return DEFAULT_INTERVAL;
    }

    @Override
    public String file() {
        return DEFAULT_FILE_NAME;
    }

    @Override
    public boolean pumpkin() {
        return false;
    }

    @Override
    public DatabaseConfig databaseConfig() {
        return DatabaseConfigDefaults.INSTANCE;
    }
}
